"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoginValidator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LoginValidator {
  constructor(options = {}) {
    (0, _defineProperty2.default)(this, "shouldValidate", void 0);
    this.shouldValidate = options.shouldValidate;
  }
  enableValidation() {
    this.shouldValidate = true;
  }
  disableValidation() {
    this.shouldValidate = false;
  }
  validateUsername(username) {
    if (!this.shouldValidate) {
      return valid();
    }
    if (!username) {
      // Elasticsearch has more stringent requirements for usernames in the Native realm. However, the login page is used for other realms,
      // such as LDAP and Active Directory. Because of that, the best validation we can do here is to ensure the username is not empty.
      return invalid(_i18n.i18n.translate('xpack.security.authentication.login.validateLogin.requiredUsernameErrorMessage', {
        defaultMessage: 'Username is required'
      }));
    }
    return valid();
  }
  validatePassword(password) {
    if (!this.shouldValidate) {
      return valid();
    }
    if (!password) {
      // Elasticsearch has more stringent requirements for passwords in the Native realm. However, the login page is used for other realms,
      // such as LDAP and Active Directory. Because of that, the best validation we can do here is to ensure the password is not empty.
      return invalid(_i18n.i18n.translate('xpack.security.authentication.login.validateLogin.requiredPasswordErrorMessage', {
        defaultMessage: 'Password is required'
      }));
    }
    return valid();
  }
  validateForLogin(username, password) {
    const {
      isInvalid: isUsernameInvalid
    } = this.validateUsername(username);
    const {
      isInvalid: isPasswordInvalid
    } = this.validatePassword(password);
    if (isUsernameInvalid || isPasswordInvalid) {
      return invalid();
    }
    return valid();
  }
}
exports.LoginValidator = LoginValidator;
function invalid(error) {
  return {
    isInvalid: true,
    error
  };
}
function valid() {
  return {
    isInvalid: false
  };
}