"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetailsTreeNode = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _use_highlight_tree_node = require("../use_highlight_tree_node");
var _lib = require("../../../lib");
var _percentage_badge = require("../../percentage_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_WIDTH_PX = 32;
const limitString = (string, limit) => `${string.slice(0, limit)}${string.length > limit ? '...' : ''}`;

/**
 * This component recursively renders a tree
 */
const ShardDetailsTreeNode = ({
  operation,
  index,
  shard
}) => {
  const [childrenVisible, setChildrenVisible] = (0, _react.useState)((0, _utils.hasVisibleChild)(operation));
  const {
    highlight,
    isHighlighted,
    id
  } = (0, _use_highlight_tree_node.useHighlightTreeNode)();
  const renderTimeRow = op => /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__tvRow"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__cell euiTextAlign--left"
  }, op.hasChildren ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: "prfDevTool__profileTree__shardDetails",
    disabled: !op.hasChildren,
    onClick: () => setChildrenVisible(!childrenVisible)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: childrenVisible ? 'arrowDown' : 'arrowRight'
  }), ' ' + op.query_type) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot"
  }), ' ' + op.query_type)), /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__cell prfDevTool__profileTree__time euiTextAlign--center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "prfDevTool__profileTree__badge euiTextAlign--center",
    style: {
      backgroundColor: op.absoluteColor
    }
  }, (0, _lib.msToPretty)(op.selfTime || 0, 1))), /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__cell prfDevTool__profileTree__totalTime"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "prfDevTool__profileTree__badge euiTextAlign--center",
    style: {
      backgroundColor: op.absoluteColor
    }
  }, (0, _lib.msToPretty)(op.time, 1))), /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__cell prfDevTool__profileTree__percentage"
  }, /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
    timePercentage: op.timePercentage,
    label: op.timePercentage + '%'
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    key: id,
    className: isHighlighted() ? 'prfDevTool__tvRow--last' : '',
    style: {
      paddingLeft: operation.depth * TAB_WIDTH_PX + 'px'
    }
  }, renderTimeRow(operation), /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__tvRow"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "prfDevTool__detail"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "none"
  }, limitString(operation.lucene || '', 120)), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    type: "button",
    "data-test-subj": "viewShardDetails",
    onClick: () => highlight({
      indexName: index.name,
      operation,
      shard
    })
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.body.viewDetailsLabel', {
    defaultMessage: 'View details'
  }))))), childrenVisible && operation.hasChildren && operation.children.map((childOp, idx) => /*#__PURE__*/_react.default.createElement(ShardDetailsTreeNode, {
    key: idx,
    operation: childOp,
    index: index,
    shard: shard
  })));
};
exports.ShardDetailsTreeNode = ShardDetailsTreeNode;