"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putUpdateNative = void 0;
var _ = require("..");
var _connectors = require("../types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const putUpdateNative = async (client, connectorId, isNative) => {
  const result = await client.update({
    doc: {
      is_native: isNative,
      status: _connectors.ConnectorStatus.CONFIGURED
    },
    id: connectorId,
    index: _.CONNECTORS_INDEX
  });
  return result;
};
exports.putUpdateNative = putUpdateNative;