"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagsFromReferences = exports.getTagIdsFromReferences = exports.getTag = exports.getObjectTags = exports.convertTagNameToId = exports.byNameTagSorter = void 0;
Object.defineProperty(exports, "tagIdToReference", {
  enumerable: true,
  get: function () {
    return _references.tagIdToReference;
  }
});
exports.testSubjFriendly = void 0;
Object.defineProperty(exports, "updateTagsReferences", {
  enumerable: true,
  get: function () {
    return _references.replaceTagReferences;
  }
});
var _common = require("../common");
var _references = require("../common/references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getObjectTags = (object, allTags) => {
  return getTagsFromReferences(object.references, allTags);
};
exports.getObjectTags = getObjectTags;
const getTagsFromReferences = (references, allTags) => {
  const tagReferences = references.filter(ref => ref.type === _common.tagSavedObjectTypeName);
  const foundTags = [];
  const missingRefs = [];
  tagReferences.forEach(ref => {
    const found = allTags.find(tag => tag.id === ref.id);
    if (found) {
      foundTags.push(found);
    } else {
      missingRefs.push(ref);
    }
  });
  return {
    tags: foundTags,
    missingRefs
  };
};
exports.getTagsFromReferences = getTagsFromReferences;
const convertTagNameToId = (tagName, allTags) => {
  const found = allTags.find(tag => tag.name === tagName);
  return found === null || found === void 0 ? void 0 : found.id;
};
exports.convertTagNameToId = convertTagNameToId;
const byNameTagSorter = (tagA, tagB) => {
  return tagA.name.localeCompare(tagB.name);
};
exports.byNameTagSorter = byNameTagSorter;
const getTag = (tagId, allTags) => {
  return allTags.find(({
    id
  }) => id === tagId);
};
exports.getTag = getTag;
const testSubjFriendly = name => {
  return name.replace(' ', '_');
};
exports.testSubjFriendly = testSubjFriendly;
const getTagIdsFromReferences = references => {
  return references.filter(ref => ref.type === _common.tagSavedObjectTypeName).map(({
    id
  }) => id);
};
exports.getTagIdsFromReferences = getTagIdsFromReferences;