"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssignFlyoutResultList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssignFlyoutResultList = ({
  results,
  isLoading,
  initialStatus,
  overrides,
  onChange
}) => {
  const options = results.map(result => {
    var _result$icon;
    const key = (0, _utils.getKey)(result);
    const overriddenStatus = (0, _utils.getOverriddenStatus)(initialStatus[key], overrides[key]);
    const checkedStatus = overriddenStatus === 'full' ? 'on' : undefined;
    const statusIcon = overriddenStatus === 'full' ? 'check' : overriddenStatus === 'none' ? 'empty' : 'partial';
    const assignmentAction = (0, _utils.getAssignmentAction)(initialStatus[key], overrides[key]);
    return {
      label: result.title,
      key,
      'data-test-subj': `assign-result-${result.type}-${result.id}`,
      checked: checkedStatus,
      previously: checkedStatus,
      showIcons: false,
      prepend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        className: `tagAssignFlyout__selectionIcon status-${overriddenStatus}`,
        type: statusIcon,
        "data-test-subj": "assign-result-status"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: (_result$icon = result.icon) !== null && _result$icon !== void 0 ? _result$icon : 'empty',
        title: result.type
      })),
      append: /*#__PURE__*/_react.default.createElement(ResultActionLabel, {
        action: assignmentAction
      })
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    height: "full",
    "data-test-subj": "assignFlyoutResultList",
    "aria-label": "Saved objects which can be assigned to this tag",
    options: options,
    allowExclusions: false,
    isLoading: isLoading,
    onChange: newOptions => {
      const newOverrides = newOptions.reduce((memo, option) => {
        if (option.checked === option.previously) {
          return memo;
        }
        return {
          ...memo,
          [option.key]: option.checked === 'on' ? 'selected' : 'deselected'
        };
      }, {});
      onChange(newOverrides);
    }
  }, list => list);
};
exports.AssignFlyoutResultList = AssignFlyoutResultList;
const ResultActionLabel = ({
  action
}) => {
  if (action === 'unchanged') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    style: {
      display: 'inline-block'
    }
  }, action === 'added' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.resultList.addedLabel",
    defaultMessage: "Added"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.resultList.removedLabel",
    defaultMessage: "Removed"
  }));
};