"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expandShorthand = void 0;
var _lodash = require("lodash");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// import from ./common/types to prevent circular dependency of kibana_utils <-> data plugin

/** @private */

/** @public */
const expandShorthand = sh => {
  return (0, _lodash.mapValues)(sh, val => {
    const fieldMap = (0, _lodash.isString)(val) ? {
      type: val
    } : val;
    const json = {
      type: _public.ES_FIELD_TYPES.TEXT,
      _serialize(v) {
        if (v) return JSON.stringify(v);
      },
      _deserialize(v) {
        if (v) return JSON.parse(v);
      }
    };
    return fieldMap.type === 'json' ? json : fieldMap;
  });
};
exports.expandShorthand = expandShorthand;