"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.displayDuplicateTitleConfirmModal = displayDuplicateTitleConfirmModal;
var _i18n = require("@kbn/i18n");
var _constants = require("../../constants");
var _confirm_modal_promise = require("./confirm_modal_promise");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function displayDuplicateTitleConfirmModal(savedObject, overlays) {
  const confirmMessage = _i18n.i18n.translate('savedObjects.confirmModal.saveDuplicateConfirmationMessage', {
    defaultMessage: `A {name} with the title '{title}' already exists. Would you like to save anyway?`,
    values: {
      title: savedObject.title,
      name: savedObject.getDisplayName()
    }
  });
  const confirmButtonText = _i18n.i18n.translate('savedObjects.confirmModal.saveDuplicateButtonLabel', {
    defaultMessage: 'Save {name}',
    values: {
      name: savedObject.getDisplayName()
    }
  });
  try {
    return (0, _confirm_modal_promise.confirmModalPromise)(confirmMessage, '', confirmButtonText, overlays);
  } catch (_) {
    return Promise.reject(new Error(_constants.SAVE_DUPLICATE_REJECTED));
  }
}