"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedObjectsManagementAction {
  constructor() {
    (0, _defineProperty2.default)(this, "refreshOnFinish", void 0);
    (0, _defineProperty2.default)(this, "callbacks", []);
    (0, _defineProperty2.default)(this, "actionContext", null);
    (0, _defineProperty2.default)(this, "record", null);
  }
  setActionContext(actionContext) {
    this.actionContext = actionContext;
  }
  registerOnFinishCallback(callback) {
    this.callbacks.push(callback);
  }
  start(record) {
    this.record = record;
  }
  finish() {
    this.record = null;
    this.callbacks.forEach(callback => callback());
  }
}
exports.SavedObjectsManagementAction = SavedObjectsManagementAction;