"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareToSpaceSavedObjectsManagementColumn = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../types");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const columnName = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.columnTitle', {
  defaultMessage: 'Spaces'
});
const columnDescription = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.columnDescription', {
  defaultMessage: 'The spaces that this object is currently assigned to'
});
const isolatedObjectTypeTitle = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.isolatedObjectTypeTitle', {
  defaultMessage: 'Isolated saved object'
});
const isolatedObjectTypeContent = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.isolatedObjectTypeContent', {
  defaultMessage: 'This saved object is available in only one space, it cannot be assigned to multiple spaces.'
});
const shareableSoonObjectTypeTitle = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.shareableSoonObjectTypeTitle', {
  defaultMessage: 'Coming soon: Assign saved object to multiple spaces'
});
const shareableSoonObjectTypeContent = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.shareableSoonObjectTypeContent', {
  defaultMessage: 'This saved object is available in only one space. In a future release, you can assign it to multiple spaces.'
});
const globalObjectTypeTitle = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.globalObjectTypeTitle', {
  defaultMessage: 'Global saved object'
});
const globalObjectTypeContent = _i18n.i18n.translate('savedObjectsManagement.shareToSpace.globalObjectTypeContent', {
  defaultMessage: 'This saved object is available in all spaces and cannot be changed.'
});
const Wrapper = ({
  objectType,
  objectNamespaceType,
  spacesApiUi,
  capabilities,
  spaceListProps,
  flyoutProps
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  function listOnClick() {
    setShowFlyout(true);
  }
  function onClose() {
    var _flyoutProps$onClose;
    setShowFlyout(false);
    (_flyoutProps$onClose = flyoutProps.onClose) === null || _flyoutProps$onClose === void 0 ? void 0 : _flyoutProps$onClose.call(flyoutProps);
  }
  const LazySpaceList = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceList, [spacesApiUi]);
  const LazyShareToSpaceFlyout = (0, _react.useMemo)(() => spacesApiUi.components.getShareToSpaceFlyout, [spacesApiUi]);
  const LazySpaceAvatar = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceAvatar, [spacesApiUi]);
  if (objectNamespaceType === 'single' || objectNamespaceType === 'multiple-isolated') {
    const tooltipProps = _constants.SHAREABLE_SOON_OBJECT_TYPES.includes(objectType) ? {
      title: shareableSoonObjectTypeTitle,
      content: shareableSoonObjectTypeContent
    } : {
      title: isolatedObjectTypeTitle,
      content: isolatedObjectTypeContent
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, (0, _extends2.default)({
      type: "minus",
      position: "left",
      delay: "long"
    }, tooltipProps));
  } else if (objectNamespaceType === 'agnostic') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      delay: "long",
      title: globalObjectTypeTitle,
      content: globalObjectTypeContent
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      space: {
        id: '*',
        initials: '*',
        color: '#D3DAE6'
      },
      isDisabled: true,
      size: 's'
    }));
  }
  const canAssignSpaces = !capabilities || !!capabilities.savedObjectsManagement.shareIntoSpace;
  const clickProperties = canAssignSpaces ? {
    cursorStyle: 'pointer',
    listOnClick
  } : {
    cursorStyle: 'not-allowed'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LazySpaceList, (0, _extends2.default)({}, spaceListProps, clickProperties)), showFlyout && /*#__PURE__*/_react.default.createElement(LazyShareToSpaceFlyout, (0, _extends2.default)({}, flyoutProps, {
    onClose: onClose
  })));
};
class ShareToSpaceSavedObjectsManagementColumn extends _types.SavedObjectsManagementColumn {
  constructor(spacesApiUi) {
    super();
    (0, _defineProperty2.default)(this, "id", 'share_saved_objects_to_space');
    (0, _defineProperty2.default)(this, "euiColumn", {
      field: 'namespaces',
      name: columnName,
      description: columnDescription,
      render: (namespaces, record) => {
        var _this$columnContext;
        const spaceListProps = {
          namespaces: namespaces !== null && namespaces !== void 0 ? namespaces : [],
          behaviorContext: 'outside-space'
        };
        const flyoutProps = {
          savedObjectTarget: {
            type: record.type,
            id: record.id,
            namespaces: namespaces !== null && namespaces !== void 0 ? namespaces : [],
            title: record.meta.title,
            icon: record.meta.icon
          },
          flyoutIcon: 'share',
          onUpdate: updatedObjects => this.objectsToRefresh = [...updatedObjects],
          onClose: this.onClose,
          enableCreateCopyCallout: true,
          enableCreateNewSpaceLink: true
        };
        return /*#__PURE__*/_react.default.createElement(Wrapper, {
          objectType: record.type,
          objectNamespaceType: record.meta.namespaceType,
          spacesApiUi: this.spacesApiUi,
          capabilities: (_this$columnContext = this.columnContext) === null || _this$columnContext === void 0 ? void 0 : _this$columnContext.capabilities,
          spaceListProps: spaceListProps,
          flyoutProps: flyoutProps
        });
      }
    });
    (0, _defineProperty2.default)(this, "refreshOnFinish", () => this.objectsToRefresh);
    (0, _defineProperty2.default)(this, "objectsToRefresh", []);
    (0, _defineProperty2.default)(this, "onClose", () => {
      this.finish();
    });
    this.spacesApiUi = spacesApiUi;
  }
}
exports.ShareToSpaceSavedObjectsManagementColumn = ShareToSpaceSavedObjectsManagementColumn;