"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedObjectLabel = getSavedObjectLabel;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns the label to be used for given saved object type.
 */
function getSavedObjectLabel(type, types) {
  var _typeInfo$displayName;
  const typeInfo = types.find(t => t.name === type);
  return (_typeInfo$displayName = typeInfo === null || typeInfo === void 0 ? void 0 : typeInfo.displayName) !== null && _typeInfo$displayName !== void 0 ? _typeInfo$displayName : type;
}