"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_MODULE = exports.ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_REFERENCE = exports.ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_NAME = exports.ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_ID = exports.ALERT_THREAT_TECHNIQUE_REFERENCE = exports.ALERT_THREAT_TECHNIQUE_NAME = exports.ALERT_THREAT_TECHNIQUE_ID = exports.ALERT_THREAT_TACTIC_REFERENCE = exports.ALERT_THREAT_TACTIC_NAME = exports.ALERT_THREAT_TACTIC_ID = exports.ALERT_THREAT_FRAMEWORK = exports.ALERT_RULE_NAMESPACE_FIELD = exports.ALERT_RULE_EXCEPTIONS_LIST = exports.ALERT_GROUP_VALUE = exports.ALERT_GROUP_FIELD = exports.ALERT_GROUP = exports.ALERT_EVALUATION_VALUES = exports.ALERT_EVALUATION_VALUE = exports.ALERT_EVALUATION_THRESHOLD = exports.ALERT_CONTEXT = exports.ALERT_BUILDING_BLOCK_TYPE = void 0;
var _default_alerts_as_data = require("./default_alerts_as_data");
var _legacy_alerts_as_data = require("./legacy_alerts_as_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// The following fields were identified as technical field names but were not defined in the
// rule registry technical component template. We will leave these here for backwards
// compatibility but these consts should be moved to the plugin that uses them
const ALERT_RULE_THREAT_NAMESPACE = `${_default_alerts_as_data.ALERT_RULE_NAMESPACE}.threat`;
const EVENT_MODULE = 'event.module';

// Fields pertaining to the alert
exports.EVENT_MODULE = EVENT_MODULE;
const ALERT_BUILDING_BLOCK_TYPE = `${_default_alerts_as_data.ALERT_NAMESPACE}.building_block_type`;
exports.ALERT_BUILDING_BLOCK_TYPE = ALERT_BUILDING_BLOCK_TYPE;
const ALERT_EVALUATION_THRESHOLD = `${_default_alerts_as_data.ALERT_NAMESPACE}.evaluation.threshold`;
exports.ALERT_EVALUATION_THRESHOLD = ALERT_EVALUATION_THRESHOLD;
const ALERT_EVALUATION_VALUE = `${_default_alerts_as_data.ALERT_NAMESPACE}.evaluation.value`;
exports.ALERT_EVALUATION_VALUE = ALERT_EVALUATION_VALUE;
const ALERT_CONTEXT = `${_default_alerts_as_data.ALERT_NAMESPACE}.context`;
exports.ALERT_CONTEXT = ALERT_CONTEXT;
const ALERT_EVALUATION_VALUES = `${_default_alerts_as_data.ALERT_NAMESPACE}.evaluation.values`;
exports.ALERT_EVALUATION_VALUES = ALERT_EVALUATION_VALUES;
const ALERT_GROUP = `${_default_alerts_as_data.ALERT_NAMESPACE}.group`;
exports.ALERT_GROUP = ALERT_GROUP;
const ALERT_GROUP_FIELD = `${ALERT_GROUP}.field`;
exports.ALERT_GROUP_FIELD = ALERT_GROUP_FIELD;
const ALERT_GROUP_VALUE = `${ALERT_GROUP}.value`;

// Fields pertaining to the rule associated with the alert
exports.ALERT_GROUP_VALUE = ALERT_GROUP_VALUE;
const ALERT_RULE_EXCEPTIONS_LIST = `${_default_alerts_as_data.ALERT_RULE_NAMESPACE}.exceptions_list`;
exports.ALERT_RULE_EXCEPTIONS_LIST = ALERT_RULE_EXCEPTIONS_LIST;
const ALERT_RULE_NAMESPACE_FIELD = `${_default_alerts_as_data.ALERT_RULE_NAMESPACE}.namespace`;

// Fields pertaining to the threat tactic associated with the rule
exports.ALERT_RULE_NAMESPACE_FIELD = ALERT_RULE_NAMESPACE_FIELD;
const ALERT_THREAT_FRAMEWORK = `${ALERT_RULE_THREAT_NAMESPACE}.framework`;
exports.ALERT_THREAT_FRAMEWORK = ALERT_THREAT_FRAMEWORK;
const ALERT_THREAT_TACTIC_ID = `${ALERT_RULE_THREAT_NAMESPACE}.tactic.id`;
exports.ALERT_THREAT_TACTIC_ID = ALERT_THREAT_TACTIC_ID;
const ALERT_THREAT_TACTIC_NAME = `${ALERT_RULE_THREAT_NAMESPACE}.tactic.name`;
exports.ALERT_THREAT_TACTIC_NAME = ALERT_THREAT_TACTIC_NAME;
const ALERT_THREAT_TACTIC_REFERENCE = `${ALERT_RULE_THREAT_NAMESPACE}.tactic.reference`;
exports.ALERT_THREAT_TACTIC_REFERENCE = ALERT_THREAT_TACTIC_REFERENCE;
const ALERT_THREAT_TECHNIQUE_ID = `${ALERT_RULE_THREAT_NAMESPACE}.technique.id`;
exports.ALERT_THREAT_TECHNIQUE_ID = ALERT_THREAT_TECHNIQUE_ID;
const ALERT_THREAT_TECHNIQUE_NAME = `${ALERT_RULE_THREAT_NAMESPACE}.technique.name`;
exports.ALERT_THREAT_TECHNIQUE_NAME = ALERT_THREAT_TECHNIQUE_NAME;
const ALERT_THREAT_TECHNIQUE_REFERENCE = `${ALERT_RULE_THREAT_NAMESPACE}.technique.reference`;
exports.ALERT_THREAT_TECHNIQUE_REFERENCE = ALERT_THREAT_TECHNIQUE_REFERENCE;
const ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_ID = `${ALERT_RULE_THREAT_NAMESPACE}.technique.subtechnique.id`;
exports.ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_ID = ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_ID;
const ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_NAME = `${ALERT_RULE_THREAT_NAMESPACE}.technique.subtechnique.name`;
exports.ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_NAME = ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_NAME;
const ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_REFERENCE = `${ALERT_RULE_THREAT_NAMESPACE}.technique.subtechnique.reference`;
exports.ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_REFERENCE = ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_REFERENCE;
const namespaces = {
  KIBANA_NAMESPACE: _default_alerts_as_data.KIBANA_NAMESPACE,
  ALERT_NAMESPACE: _default_alerts_as_data.ALERT_NAMESPACE,
  ALERT_RULE_NAMESPACE: _default_alerts_as_data.ALERT_RULE_NAMESPACE
};
const fields = {
  ECS_VERSION: _legacy_alerts_as_data.ECS_VERSION,
  EVENT_KIND: _legacy_alerts_as_data.EVENT_KIND,
  EVENT_ACTION: _legacy_alerts_as_data.EVENT_ACTION,
  EVENT_MODULE,
  TAGS: _legacy_alerts_as_data.TAGS,
  TIMESTAMP: _default_alerts_as_data.TIMESTAMP,
  ALERT_ACTION_GROUP: _default_alerts_as_data.ALERT_ACTION_GROUP,
  ALERT_BUILDING_BLOCK_TYPE,
  ALERT_DURATION: _default_alerts_as_data.ALERT_DURATION,
  ALERT_END: _default_alerts_as_data.ALERT_END,
  ALERT_EVALUATION_THRESHOLD,
  ALERT_EVALUATION_VALUE,
  ALERT_EVALUATION_VALUES,
  ALERT_GROUP,
  ALERT_GROUP_FIELD,
  ALERT_GROUP_VALUE,
  ALERT_FLAPPING: _default_alerts_as_data.ALERT_FLAPPING,
  ALERT_MAINTENANCE_WINDOW_IDS: _default_alerts_as_data.ALERT_MAINTENANCE_WINDOW_IDS,
  ALERT_INSTANCE_ID: _default_alerts_as_data.ALERT_INSTANCE_ID,
  ALERT_RULE_CONSUMER: _default_alerts_as_data.ALERT_RULE_CONSUMER,
  ALERT_RULE_PRODUCER: _default_alerts_as_data.ALERT_RULE_PRODUCER,
  ALERT_REASON: _default_alerts_as_data.ALERT_REASON,
  ALERT_CONTEXT,
  ALERT_RISK_SCORE: _legacy_alerts_as_data.ALERT_RISK_SCORE,
  ALERT_CASE_IDS: _default_alerts_as_data.ALERT_CASE_IDS,
  ALERT_RULE_AUTHOR: _legacy_alerts_as_data.ALERT_RULE_AUTHOR,
  ALERT_RULE_CREATED_AT: _legacy_alerts_as_data.ALERT_RULE_CREATED_AT,
  ALERT_RULE_CREATED_BY: _legacy_alerts_as_data.ALERT_RULE_CREATED_BY,
  ALERT_RULE_DESCRIPTION: _legacy_alerts_as_data.ALERT_RULE_DESCRIPTION,
  ALERT_RULE_ENABLED: _legacy_alerts_as_data.ALERT_RULE_ENABLED,
  ALERT_RULE_EXCEPTIONS_LIST,
  ALERT_RULE_EXECUTION_UUID: _default_alerts_as_data.ALERT_RULE_EXECUTION_UUID,
  ALERT_RULE_FROM: _legacy_alerts_as_data.ALERT_RULE_FROM,
  ALERT_RULE_INTERVAL: _legacy_alerts_as_data.ALERT_RULE_INTERVAL,
  ALERT_RULE_LICENSE: _legacy_alerts_as_data.ALERT_RULE_LICENSE,
  ALERT_RULE_NAME: _default_alerts_as_data.ALERT_RULE_NAME,
  ALERT_RULE_NAMESPACE_FIELD,
  ALERT_RULE_NOTE: _legacy_alerts_as_data.ALERT_RULE_NOTE,
  ALERT_RULE_PARAMETERS: _default_alerts_as_data.ALERT_RULE_PARAMETERS,
  ALERT_RULE_REFERENCES: _legacy_alerts_as_data.ALERT_RULE_REFERENCES,
  ALERT_RULE_RULE_ID: _legacy_alerts_as_data.ALERT_RULE_RULE_ID,
  ALERT_RULE_RULE_NAME_OVERRIDE: _legacy_alerts_as_data.ALERT_RULE_RULE_NAME_OVERRIDE,
  ALERT_RULE_TAGS: _default_alerts_as_data.ALERT_RULE_TAGS,
  ALERT_RULE_TO: _legacy_alerts_as_data.ALERT_RULE_TO,
  ALERT_RULE_TYPE: _legacy_alerts_as_data.ALERT_RULE_TYPE,
  ALERT_RULE_TYPE_ID: _default_alerts_as_data.ALERT_RULE_TYPE_ID,
  ALERT_RULE_UPDATED_AT: _legacy_alerts_as_data.ALERT_RULE_UPDATED_AT,
  ALERT_RULE_UPDATED_BY: _legacy_alerts_as_data.ALERT_RULE_UPDATED_BY,
  ALERT_RULE_VERSION: _legacy_alerts_as_data.ALERT_RULE_VERSION,
  ALERT_START: _default_alerts_as_data.ALERT_START,
  ALERT_TIME_RANGE: _default_alerts_as_data.ALERT_TIME_RANGE,
  ALERT_SEVERITY: _legacy_alerts_as_data.ALERT_SEVERITY,
  ALERT_STATUS: _default_alerts_as_data.ALERT_STATUS,
  ALERT_SYSTEM_STATUS: _legacy_alerts_as_data.ALERT_SYSTEM_STATUS,
  ALERT_UUID: _default_alerts_as_data.ALERT_UUID,
  ALERT_WORKFLOW_ASSIGNEE_IDS: _default_alerts_as_data.ALERT_WORKFLOW_ASSIGNEE_IDS,
  ALERT_WORKFLOW_REASON: _legacy_alerts_as_data.ALERT_WORKFLOW_REASON,
  ALERT_WORKFLOW_STATUS: _default_alerts_as_data.ALERT_WORKFLOW_STATUS,
  ALERT_WORKFLOW_TAGS: _default_alerts_as_data.ALERT_WORKFLOW_TAGS,
  ALERT_WORKFLOW_USER: _legacy_alerts_as_data.ALERT_WORKFLOW_USER,
  ALERT_RULE_UUID: _default_alerts_as_data.ALERT_RULE_UUID,
  ALERT_RULE_CATEGORY: _default_alerts_as_data.ALERT_RULE_CATEGORY,
  ALERT_THREAT_FRAMEWORK,
  ALERT_THREAT_TACTIC_ID,
  ALERT_THREAT_TACTIC_NAME,
  ALERT_THREAT_TACTIC_REFERENCE,
  ALERT_THREAT_TECHNIQUE_ID,
  ALERT_THREAT_TECHNIQUE_NAME,
  ALERT_THREAT_TECHNIQUE_REFERENCE,
  ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_ID,
  ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_NAME,
  ALERT_THREAT_TECHNIQUE_SUBTECHNIQUE_REFERENCE,
  ALERT_SUPPRESSION_TERMS: _legacy_alerts_as_data.ALERT_SUPPRESSION_TERMS,
  ALERT_SUPPRESSION_FIELD: _legacy_alerts_as_data.ALERT_SUPPRESSION_FIELD,
  ALERT_SUPPRESSION_VALUE: _legacy_alerts_as_data.ALERT_SUPPRESSION_VALUE,
  ALERT_SUPPRESSION_START: _legacy_alerts_as_data.ALERT_SUPPRESSION_START,
  ALERT_SUPPRESSION_END: _legacy_alerts_as_data.ALERT_SUPPRESSION_END,
  ALERT_SUPPRESSION_DOCS_COUNT: _legacy_alerts_as_data.ALERT_SUPPRESSION_DOCS_COUNT,
  SPACE_IDS: _default_alerts_as_data.SPACE_IDS,
  VERSION: _default_alerts_as_data.VERSION
};