"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfirmDeleteModal extends _react.Component {
  renderJobs() {
    const {
      jobs
    } = this.props;
    const jobItems = jobs.map(({
      id,
      status
    }) => {
      const startedMessage = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.startedMessage', {
        defaultMessage: 'started'
      });
      const statusText = status === 'started' ? ` (${startedMessage})` : null;
      return /*#__PURE__*/_react.default.createElement("li", {
        key: id
      }, id, statusText);
    });
    return /*#__PURE__*/_react.default.createElement("ul", null, jobItems);
  }
  render() {
    const {
      isSingleSelection,
      jobs,
      onCancel,
      onConfirm
    } = this.props;
    let title;
    let content;
    if (isSingleSelection) {
      const {
        id,
        status
      } = jobs[0];
      title = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.deleteSingleJobTitle', {
        defaultMessage: "Delete rollup job '{id}'?",
        values: {
          id
        }
      });
      if (status === 'started') {
        content = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.deleteSingleJobDescription",
          defaultMessage: "This job has been started."
        }));
      }
    } else {
      title = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.multipleDeletionTitle', {
        defaultMessage: 'Delete {count} rollup jobs?',
        values: {
          count: jobs.length
        }
      });
      content = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.multipleDeletionDescription",
        defaultMessage: "You are about to delete {isSingleSelection, plural, one {this job} other {these jobs}}",
        values: {
          isSingleSelection: isSingleSelection ? 1 : 0
        }
      })), this.renderJobs());
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: title,
      onCancel: onCancel,
      onConfirm: onConfirm,
      cancelButtonText: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.cancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      buttonColor: "danger",
      confirmButtonText: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.confirmButtonText', {
        defaultMessage: 'Delete'
      })
    }, content);
  }
}
exports.ConfirmDeleteModal = ConfirmDeleteModal;
(0, _defineProperty2.default)(ConfirmDeleteModal, "propTypes", {
  isSingleSelection: _propTypes.default.bool.isRequired,
  jobs: _propTypes.default.array.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func.isRequired
});