"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGenerationRoutesPublic = registerGenerationRoutesPublic;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _constants = require("../../../common/constants");
var _common = require("../common");
var _generate = require("../common/generate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGenerationRoutesPublic(reporting, logger) {
  const setupDeps = reporting.getPluginSetupDeps();
  const {
    router
  } = setupDeps;
  const useKibanaAccessControl = reporting.getDeprecatedAllowedRoles() === false; // true if Reporting's deprecated access control feature is disabled
  const kibanaAccessControlTags = useKibanaAccessControl ? ['access:generateReport'] : [];
  const registerPublicPostGenerationEndpoint = () => {
    const path = `${_constants.PUBLIC_ROUTES.GENERATE_PREFIX}/{exportType}`;
    router.post({
      path,
      validate: _generate.RequestHandler.getValidation(),
      options: {
        tags: kibanaAccessControlTags,
        access: 'public'
      }
    }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
      try {
        const requestHandler = new _generate.RequestHandler(reporting, user, context, path, req, res, logger);
        return await requestHandler.handleGenerateRequest(req.params.exportType, requestHandler.getJobParams());
      } catch (err) {
        if (err instanceof _coreHttpRouterServerInternal.KibanaResponse) {
          return err;
        }
        throw err;
      }
    }));
  };
  const registerPublicGetGenerationEndpoint = () => {
    // Get route to generation endpoint: show error about GET method to user
    router.get({
      path: `${_constants.PUBLIC_ROUTES.GENERATE_PREFIX}/{p*}`,
      validate: false,
      options: {
        access: 'public'
      }
    }, (_context, _req, res) => {
      return res.customError({
        statusCode: 405,
        body: 'GET is not allowed'
      });
    });
  };
  registerPublicPostGenerationEndpoint();
  registerPublicGetGenerationEndpoint();
}