"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sharedI18nTexts = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sharedI18nTexts = {
  cloud: {
    insufficientMemoryError: helpUrl => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.infoPanel.callout.cloud.insufficientMemoryError",
      defaultMessage: "Kibana needs more memory to generate this report. Check {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: helpUrl
        }, _i18n.i18n.translate('xpack.reporting.listing.infoPanel.callout.cloud.insufficientMemoryError.urlLink', {
          defaultMessage: 'RAM requirements'
        }))
      }
    })
  }
};
exports.sharedI18nTexts = sharedI18nTexts;