"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScreenCapturePanelContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reporting_panel_content = require("./reporting_panel_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ScreenCapturePanelContent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "renderOptions", () => {
      if (this.props.layoutOption === 'print') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.reporting.screenCapturePanelContent.optimizeForPrintingHelpText",
            defaultMessage: "Uses multiple pages, showing at most 2 visualizations per page"
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.reporting.screenCapturePanelContent.optimizeForPrintingLabel",
            defaultMessage: "Optimize for printing"
          }),
          checked: this.state.usePrintLayout,
          onChange: this.handlePrintLayoutChange,
          "data-test-subj": "usePrintLayout"
        }));
      }
      if (this.props.layoutOption === 'canvas') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.reporting.screenCapturePanelContent.canvasLayoutHelpText",
            defaultMessage: "Remove borders and footer logo"
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.reporting.screenCapturePanelContent.canvasLayoutLabel",
            defaultMessage: "Full page layout"
          }),
          checked: this.state.useCanvasLayout,
          onChange: this.handleCanvasLayoutChange,
          "data-test-subj": "reportModeToggle"
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "handlePrintLayoutChange", evt => {
      this.setState({
        usePrintLayout: evt.target.checked,
        useCanvasLayout: false
      });
    });
    (0, _defineProperty2.default)(this, "handleCanvasLayoutChange", evt => {
      this.setState({
        useCanvasLayout: evt.target.checked,
        usePrintLayout: false
      });
    });
    (0, _defineProperty2.default)(this, "getLayout", () => {
      const {
        layout: outerLayout
      } = this.props.getJobParams();
      let dimensions = outerLayout === null || outerLayout === void 0 ? void 0 : outerLayout.dimensions;
      if (!dimensions) {
        const el = document.querySelector('[data-shared-items-container]');
        const {
          height,
          width
        } = el ? el.getBoundingClientRect() : {
          height: 768,
          width: 1024
        };
        dimensions = {
          height,
          width
        };
      }
      if (this.state.usePrintLayout) {
        return {
          id: 'print',
          dimensions
        };
      }
      if (this.state.useCanvasLayout) {
        return {
          id: 'canvas',
          dimensions
        };
      }
      return {
        id: 'preserve_layout',
        dimensions
      };
    });
    (0, _defineProperty2.default)(this, "getJobParams", () => {
      return {
        ...this.props.getJobParams(),
        layout: this.getLayout()
      };
    });
    this.state = {
      usePrintLayout: false,
      useCanvasLayout: false
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_reporting_panel_content.ReportingPanelContent, (0, _extends2.default)({}, this.props, {
      layoutId: this.getLayout().id,
      getJobParams: this.getJobParams,
      options: this.renderOptions()
    }));
  }
}
exports.ScreenCapturePanelContent = ScreenCapturePanelContent;