"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportingPanelContent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _url = _interopRequireDefault(require("url"));
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _reportingExportTypesPdfCommon = require("@kbn/reporting-export-types-pdf-common");
var _reportingExportTypesPngCommon = require("@kbn/reporting-export-types-png-common");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("./components");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Properties for displaying a share menu with Reporting features, including
 * internally-derived fields.
 */

class ReportingPanelContentUi extends _react.Component {
  constructor(_props) {
    super(_props);

    // Get objectType from job params
    (0, _defineProperty2.default)(this, "mounted", void 0);
    (0, _defineProperty2.default)(this, "getAbsoluteReportGenerationUrl", props => {
      const relativePath = this.props.apiClient.getReportingPublicJobPath(props.reportType, this.props.apiClient.getDecoratedJobParams(this.props.getJobParams(true)));
      return _url.default.resolve(window.location.href, relativePath);
    });
    (0, _defineProperty2.default)(this, "isNotSaved", () => {
      return this.props.objectId === undefined || this.props.objectId === '';
    });
    (0, _defineProperty2.default)(this, "renderGenerateReportButton", isDisabled => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: isDisabled || this.state.isCreatingReportJob,
        fullWidth: true,
        fill: true,
        onClick: this.createReportingJob,
        "data-test-subj": "generateReportButton",
        size: "s",
        isLoading: this.state.isCreatingReportJob
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.reporting.panelContent.generateButtonLabel",
        defaultMessage: "Generate {reportingType}",
        values: {
          reportingType: this.prettyPrintReportingType()
        }
      }));
    });
    (0, _defineProperty2.default)(this, "prettyPrintReportingType", () => {
      switch (this.props.reportType) {
        case _reportingExportTypesPdfCommon.PDF_REPORT_TYPE:
        case _reportingExportTypesPdfCommon.PDF_REPORT_TYPE_V2:
          return 'PDF';
        case _reportingExportTypesCsvCommon.CSV_REPORT_TYPE:
          return 'csv';
        case 'png':
        case _reportingExportTypesPngCommon.PNG_REPORT_TYPE_V2:
          return _reportingExportTypesPngCommon.PNG_REPORT_TYPE;
        default:
          return this.props.reportType;
      }
    });
    (0, _defineProperty2.default)(this, "markAsStale", () => {
      if (!this.mounted) {
        return;
      }
      this.setState({
        isStale: true
      });
    });
    (0, _defineProperty2.default)(this, "setAbsoluteReportGenerationUrl", () => {
      if (!this.mounted) {
        return;
      }
      const absoluteUrl = this.getAbsoluteReportGenerationUrl(this.props);
      this.setState({
        absoluteUrl
      });
    });
    (0, _defineProperty2.default)(this, "createReportingJob", () => {
      const {
        intl
      } = this.props;
      const decoratedJobParams = this.props.apiClient.getDecoratedJobParams(this.props.getJobParams());
      this.setState({
        isCreatingReportJob: true
      });
      return this.props.apiClient.createReportingJob(this.props.reportType, decoratedJobParams).then(() => {
        this.props.toasts.addSuccess({
          title: intl.formatMessage({
            id: 'xpack.reporting.panelContent.successfullyQueuedReportNotificationTitle',
            defaultMessage: 'Queued report for {objectType}'
          }, {
            objectType: this.state.objectType
          }),
          text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.reporting.panelContent.successfullyQueuedReportNotificationDescription",
            defaultMessage: "Track its progress in {path}.",
            values: {
              path: /*#__PURE__*/_react.default.createElement("a", {
                href: this.props.apiClient.getManagementLink()
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.reporting.publicNotifier.reportLink.reportingSectionUrlLinkLabel",
                defaultMessage: "Stack Management > Reporting"
              }))
            }
          }), {
            theme$: this.props.theme.theme$
          }),
          'data-test-subj': 'queueReportSuccess'
        });
        if (this.props.onClose) {
          this.props.onClose();
        }
        if (this.mounted) {
          this.setState({
            isCreatingReportJob: false
          });
        }
      }).catch(error => {
        this.props.toasts.addError(error, {
          title: intl.formatMessage({
            id: 'xpack.reporting.panelContent.notification.reportingErrorTitle',
            defaultMessage: 'Unable to create report'
          }),
          toastMessage:
          /*#__PURE__*/
          // eslint-disable-next-line react/no-danger
          _react.default.createElement("span", {
            dangerouslySetInnerHTML: {
              __html: error.body.message
            }
          })
        });
        if (this.mounted) {
          this.setState({
            isCreatingReportJob: false
          });
        }
      });
    });
    const {
      objectType
    } = _props.getJobParams();
    this.state = {
      isStale: false,
      absoluteUrl: this.getAbsoluteReportGenerationUrl(_props),
      layoutId: '',
      objectType,
      isCreatingReportJob: false
    };
  }
  componentDidUpdate(_prevProps, prevState) {
    if (this.props.layoutId && this.props.layoutId !== prevState.layoutId) {
      this.setState({
        ...prevState,
        absoluteUrl: this.getAbsoluteReportGenerationUrl(this.props),
        layoutId: this.props.layoutId
      });
    }
  }
  componentWillUnmount() {
    window.removeEventListener('hashchange', this.markAsStale);
    window.removeEventListener('resize', this.setAbsoluteReportGenerationUrl);
    this.mounted = false;
  }
  componentDidMount() {
    this.mounted = true;
    window.addEventListener('hashchange', this.markAsStale, false);
    window.addEventListener('resize', this.setAbsoluteReportGenerationUrl);
  }
  renderCopyURLButton({
    isUnsaved,
    exceedsMaxLength
  }) {
    if (isUnsaved) {
      if (exceedsMaxLength) {
        return /*#__PURE__*/_react.default.createElement(_components.ErrorUrlTooLongPanel, {
          isUnsaved: true
        });
      }
      return /*#__PURE__*/_react.default.createElement(_components.ErrorUnsavedWorkPanel, null);
    } else if (exceedsMaxLength) {
      return /*#__PURE__*/_react.default.createElement(_components.ErrorUrlTooLongPanel, {
        isUnsaved: false
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: this.state.absoluteUrl,
      anchorClassName: "eui-displayBlock"
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: isUnsaved ? 'warning' : 'primary',
      fullWidth: true,
      onClick: copy,
      size: "s",
      "data-test-subj": "shareReportingCopyURL"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.panelContent.copyUrlButtonLabel",
      defaultMessage: "Copy POST URL"
    })));
  }
  render() {
    const isUnsaved = this.isNotSaved() || this.props.isDirty || this.state.isStale;
    if (this.props.requiresSavedState && isUnsaved) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        className: "kbnShareContextMenu__finalPanel",
        "data-test-subj": "shareReportingForm"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.reporting.panelContent.saveWorkDescription",
          defaultMessage: "Please save your work before generating a report."
        })
      }, this.renderGenerateReportButton(true)));
    }
    const exceedsMaxLength = this.state.absoluteUrl.length >= (0, _constants.getMaxUrlLength)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      className: "kbnShareContextMenu__finalPanel",
      "data-test-subj": "shareReportingForm"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.panelContent.generationTimeDescription",
      defaultMessage: "{reportingType}s can take a minute or two to generate based upon the size of your {objectType}.",
      description: "Here 'reportingType' can be 'PDF' or 'CSV'",
      values: {
        reportingType: this.prettyPrintReportingType(),
        objectType: this.state.objectType
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), this.props.options, this.renderGenerateReportButton(false), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      style: {
        width: 'auto',
        marginLeft: '-16px',
        marginRight: '-16px'
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "advanced-options",
      buttonContent: _i18n.i18n.translate('xpack.reporting.panelContent.advancedOptions', {
        defaultMessage: 'Advanced options'
      }),
      paddingSize: "none",
      "data-test-subj": "shareReportingAdvancedOptionsButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.panelContent.howToCallGenerationDescription",
      defaultMessage: "Alternatively, copy this POST URL to call generation from outside Kibana or from Watcher."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), this.renderCopyURLButton({
      isUnsaved,
      exceedsMaxLength
    })));
  }
}
const ReportingPanelContent = (0, _i18nReact.injectI18n)(ReportingPanelContentUi);
exports.ReportingPanelContent = ReportingPanelContent;