"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var React = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _ = require(".");
var _default_status_context = require("../lib/default_status_context");
var _reporting_api_client = require("../lib/reporting_api_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function mountManagementSection(coreStart, license$, dataService, shareService, config, apiClient, params) {
  const services = {
    http: coreStart.http,
    application: coreStart.application,
    uiSettings: coreStart.uiSettings,
    docLinks: coreStart.docLinks,
    data: dataService,
    share: shareService
  };
  (0, _reactDom.render)( /*#__PURE__*/React.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$: params.theme$
    }
  }, /*#__PURE__*/React.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/React.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/React.createElement(_reporting_api_client.InternalApiClientProvider, {
    apiClient: apiClient
  }, /*#__PURE__*/React.createElement(_default_status_context.PolicyStatusContextProvider, {
    config: config
  }, /*#__PURE__*/React.createElement(_.ReportListing, {
    apiClient: apiClient,
    toasts: coreStart.notifications.toasts,
    license$: license$,
    config: config,
    redirect: coreStart.application.navigateToApp,
    navigateToUrl: coreStart.application.navigateToUrl,
    urlService: shareService.url
  })))))), params.element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(params.element);
  };
}