"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportStatusIndicator = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("@kbn/reporting-common/constants");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  completed: _i18n.i18n.translate('xpack.reporting.statusIndicator.completedLabel', {
    defaultMessage: 'Done'
  }),
  completedWithWarnings: _i18n.i18n.translate('xpack.reporting.statusIndicator.completedWithWarningsLabel', {
    defaultMessage: 'Done, warnings detected'
  }),
  pending: _i18n.i18n.translate('xpack.reporting.statusIndicator.pendingLabel', {
    defaultMessage: 'Pending'
  }),
  processing: ({
    attempt,
    of
  }) => of !== undefined ? _i18n.i18n.translate('xpack.reporting.statusIndicator.processingMaxAttemptsLabel', {
    defaultMessage: `Processing, attempt {attempt} of {of}`,
    values: {
      attempt,
      of
    }
  }) : _i18n.i18n.translate('xpack.reporting.statusIndicator.processingLabel', {
    defaultMessage: `Processing, attempt {attempt}`,
    values: {
      attempt
    }
  }),
  failed: _i18n.i18n.translate('xpack.reporting.statusIndicator.failedLabel', {
    defaultMessage: 'Failed'
  }),
  unknown: _i18n.i18n.translate('xpack.reporting.statusIndicator.unknownLabel', {
    defaultMessage: 'Unknown'
  }),
  lastStatusUpdate: ({
    date
  }) => _i18n.i18n.translate('xpack.reporting.statusIndicator.lastStatusUpdateLabel', {
    defaultMessage: 'Updated at {date}',
    values: {
      date
    }
  })
};
const ReportStatusIndicator = ({
  job
}) => {
  const hasIssues = (0, _react.useMemo)(() => (0, _utils.jobHasIssues)(job), [job]);
  let icon;
  let statusText;
  switch (job.status) {
    case _constants.JOB_STATUS.COMPLETED:
      if (hasIssues) {
        icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "warning"
        });
        statusText = i18nTexts.completedWithWarnings;
        break;
      }
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "checkInCircleFilled",
        color: "success"
      });
      statusText = i18nTexts.completed;
      break;
    case _constants.JOB_STATUS.WARNINGS:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning"
      });
      statusText = i18nTexts.completedWithWarnings;
      break;
    case _constants.JOB_STATUS.PENDING:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
      statusText = i18nTexts.pending;
      break;
    case _constants.JOB_STATUS.PROCESSING:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
      statusText = i18nTexts.processing({
        attempt: job.attempts,
        of: job.max_attempts
      });
      break;
    case _constants.JOB_STATUS.FAILED:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        color: "danger"
      });
      statusText = i18nTexts.failed;
      break;
    default:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "cross",
        color: "subdued"
      });
      statusText = i18nTexts.unknown;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18nTexts.lastStatusUpdate({
      date: job.getPrettyStatusTimestamp()
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    "aria-label": statusText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, statusText)));
};
exports.ReportStatusIndicator = ReportStatusIndicator;