"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDeleteButton = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ReportDeleteButton extends _react.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      showConfirm: false
    };
  }
  hideConfirm() {
    this.setState({
      showConfirm: false
    });
  }
  showConfirm() {
    this.setState({
      showConfirm: true
    });
  }
  renderConfirm() {
    const {
      jobsToDelete
    } = this.props;
    const title = jobsToDelete.length > 1 ? _i18n.i18n.translate('xpack.reporting.listing.table.deleteNumConfirmTitle', {
      defaultMessage: `Delete {num} reports?`,
      values: {
        num: jobsToDelete.length
      }
    }) : _i18n.i18n.translate('xpack.reporting.listing.table.deleteConfirmTitle', {
      defaultMessage: `Delete the "{name}" report?`,
      values: {
        name: jobsToDelete[0].title
      }
    });
    const message = _i18n.i18n.translate('xpack.reporting.listing.table.deleteConfirmMessage', {
      defaultMessage: `You can't recover deleted reports.`
    });
    const confirmButtonText = _i18n.i18n.translate('xpack.reporting.listing.table.deleteConfirmButton', {
      defaultMessage: `Delete`
    });
    const cancelButtonText = _i18n.i18n.translate('xpack.reporting.listing.table.deleteCancelButton', {
      defaultMessage: `Cancel`
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: title,
      onCancel: () => this.hideConfirm(),
      onConfirm: () => this.props.performDelete(),
      confirmButtonText: confirmButtonText,
      cancelButtonText: cancelButtonText,
      defaultFocusedButton: "confirm",
      buttonColor: "danger"
    }, message);
  }
  render() {
    const {
      jobsToDelete
    } = this.props;
    if (jobsToDelete.length === 0) return null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => this.showConfirm(),
      iconType: "trash",
      color: 'danger',
      "data-test-subj": "deleteReportButton"
    }, _i18n.i18n.translate('xpack.reporting.listing.table.deleteReportButton', {
      defaultMessage: `Delete {num, plural, one {report} other {reports} }`,
      values: {
        num: jobsToDelete.length
      }
    })), this.state.showConfirm ? this.renderConfirm() : null);
  }
}
exports.ReportDeleteButton = ReportDeleteButton;