"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PdfV1ExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesPdfCommon = require("@kbn/reporting-export-types-pdf-common");
var _reportingServer = require("@kbn/reporting-server");
var _generate_pdf = require("./generate_pdf");
var _validate_urls = require("./validate_urls");
var _get_custom_logo = require("./get_custom_logo");
var _get_full_urls = require("./get_full_urls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @deprecated
 */
class PdfV1ExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", 'printablePdf');
    (0, _defineProperty2.default)(this, "name", 'PDF');
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesPdfCommon.PDF_JOB_TYPE);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'pdf');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    (0, _defineProperty2.default)(this, "createJob", async ({
      relativeUrls,
      ...jobParams
    }) => {
      (0, _validate_urls.validateUrls)(relativeUrls);

      // return the payload
      return {
        ...jobParams,
        isDeprecated: true,
        forceNow: new Date().toISOString(),
        objects: relativeUrls.map(u => ({
          relativeUrl: u
        }))
      };
    });
    (0, _defineProperty2.default)(this, "runTask", async (jobId, job, cancellationToken, stream) => {
      const jobLogger = this.logger.get(`execute-job:${jobId}`);
      const apmTrans = _elasticApmNode.default.startTransaction('execute-job-pdf', _reportingCommon.REPORTING_TRANSACTION_TYPE);
      const apmGetAssets = apmTrans.startSpan('get-assets', 'setup');
      let apmGeneratePdf;
      const process$ = (0, _rxjs.of)(1).pipe((0, _operators.mergeMap)(() => (0, _reportingServer.decryptJobHeaders)(this.config.encryptionKey, job.headers, jobLogger)), (0, _operators.mergeMap)(async headers => {
        const fakeRequest = this.getFakeRequest(headers, job.spaceId, jobLogger);
        const uiSettingsClient = await this.getUiSettingsClient(fakeRequest);
        return (0, _get_custom_logo.getCustomLogo)(uiSettingsClient, headers);
      }), (0, _operators.mergeMap)(({
        headers,
        logo
      }) => {
        const urls = (0, _get_full_urls.getFullUrls)(this.getServerInfo(), this.config, job);
        const {
          browserTimezone,
          layout,
          title
        } = job;
        apmGetAssets === null || apmGetAssets === void 0 ? void 0 : apmGetAssets.end();
        apmGeneratePdf = apmTrans.startSpan('generate-pdf-pipeline', 'execute');
        return (0, _generate_pdf.generatePdfObservable)(() => this.startDeps.screenshotting.getScreenshots({
          format: 'pdf',
          title,
          logo,
          urls,
          browserTimezone,
          headers,
          layout
        }), {
          format: 'pdf',
          title,
          logo,
          urls,
          browserTimezone,
          headers,
          layout
        });
      }), (0, _operators.tap)(({
        buffer
      }) => {
        var _apmGeneratePdf;
        (_apmGeneratePdf = apmGeneratePdf) === null || _apmGeneratePdf === void 0 ? void 0 : _apmGeneratePdf.end();
        if (buffer) {
          stream.write(buffer);
        }
      }), (0, _operators.map)(({
        metrics,
        warnings
      }) => ({
        content_type: 'application/pdf',
        metrics: {
          pdf: metrics
        },
        warnings
      })), (0, _operators.catchError)(err => {
        jobLogger.error(err);
        return (0, _rxjs.throwError)(err);
      }));
      const stop$ = (0, _rxjs.fromEventPattern)(cancellationToken.on);
      apmTrans.end();
      return (0, _rxjs.lastValueFrom)(process$.pipe((0, _operators.takeUntil)(stop$)));
    });
    this.logger = this.logger.get('png-export-v1');
  }
}
exports.PdfV1ExportType = PdfV1ExportType;