"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _app_context = require("../../../app_context");
var _documentation = require("../../../services/documentation");
var _request_flyout = require("./request_flyout");
var _components = require("./components");
var _validators = require("./validators");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultClusterValues = {
  name: '',
  seeds: [],
  skipUnavailable: false,
  nodeConnections: 3,
  proxyAddress: '',
  proxySocketConnections: 18,
  serverName: ''
};
const ERROR_TITLE_ID = 'removeClustersErrorTitle';
const ERROR_LIST_ID = 'removeClustersErrorList';
class RemoteClusterForm extends _react.Component {
  constructor(props, context) {
    super(props, context);
    (0, _defineProperty2.default)(this, "generateId", void 0);
    (0, _defineProperty2.default)(this, "toggleRequest", () => {
      this.setState(({
        isRequestVisible
      }) => ({
        isRequestVisible: !isRequestVisible
      }));
    });
    (0, _defineProperty2.default)(this, "onFieldsChange", changedFields => {
      const {
        isCloudEnabled
      } = this.context;

      // when cloudUrl changes, fill proxy address and server name
      const {
        cloudUrl
      } = changedFields;
      if (cloudUrl) {
        const {
          proxyAddress,
          serverName
        } = (0, _validators.convertCloudUrlToProxyConnection)(cloudUrl);
        changedFields = {
          ...changedFields,
          proxyAddress,
          serverName
        };
      }
      this.setState(({
        fields: prevFields
      }) => {
        const newFields = {
          ...prevFields,
          ...changedFields
        };
        return {
          fields: newFields,
          fieldsErrors: (0, _validators.validateCluster)(newFields, isCloudEnabled)
        };
      });
    });
    (0, _defineProperty2.default)(this, "save", () => {
      const {
        save
      } = this.props;
      if (this.hasErrors()) {
        this.setState({
          areErrorsVisible: true
        });
        return;
      }
      const cluster = this.getCluster();
      save(cluster);
    });
    (0, _defineProperty2.default)(this, "onSkipUnavailableChange", e => {
      const skipUnavailable = e.target.checked;
      this.onFieldsChange({
        skipUnavailable
      });
    });
    (0, _defineProperty2.default)(this, "resetToDefault", fieldName => {
      this.onFieldsChange({
        [fieldName]: defaultClusterValues[fieldName]
      });
    });
    (0, _defineProperty2.default)(this, "hasErrors", () => {
      const {
        fieldsErrors
      } = this.state;
      const errorValues = Object.values(fieldsErrors);
      return errorValues.some(error => error != null);
    });
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areErrorsVisible,
        fieldsErrors: {
          name: errorClusterName,
          seeds: errorsSeeds,
          proxyAddress: errorProxyAddress,
          serverName: errorServerName,
          cloudUrl: errorCloudUrl
        }
      } = this.state;
      const hasErrors = this.hasErrors();
      if (!areErrorsVisible || !hasErrors) {
        return null;
      }
      const errorExplanations = [];
      if (errorClusterName) {
        errorExplanations.push({
          key: 'nameExplanation',
          field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputNameErrorMessage', {
            defaultMessage: 'The "Name" field is invalid.'
          }),
          error: errorClusterName
        });
      }
      if (errorsSeeds) {
        errorExplanations.push({
          key: 'seedsExplanation',
          field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputSeedsErrorMessage', {
            defaultMessage: 'The "Seed nodes" field is invalid.'
          }),
          error: errorsSeeds
        });
      }
      if (errorProxyAddress) {
        errorExplanations.push({
          key: 'proxyAddressExplanation',
          field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputProxyErrorMessage', {
            defaultMessage: 'The "Proxy address" field is invalid.'
          }),
          error: errorProxyAddress
        });
      }
      if (errorServerName) {
        errorExplanations.push({
          key: 'serverNameExplanation',
          field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputServerNameErrorMessage', {
            defaultMessage: 'The "Server name" field is invalid.'
          }),
          error: errorServerName
        });
      }
      if (errorCloudUrl) {
        errorExplanations.push({
          key: 'cloudUrlExplanation',
          field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputcloudUrlErrorMessage', {
            defaultMessage: 'The "Elasticsearch endpoint URL" field is invalid.'
          }),
          error: errorCloudUrl
        });
      }
      const messagesToBeRendered = errorExplanations.length && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("dl", {
        id: this.generateId(ERROR_LIST_ID),
        "aria-labelledby": this.generateId(ERROR_TITLE_ID)
      }, errorExplanations.map(({
        key,
        field,
        error
      }) => /*#__PURE__*/_react.default.createElement("div", {
        key: key
      }, /*#__PURE__*/_react.default.createElement("dt", null, field), /*#__PURE__*/_react.default.createElement("dd", null, error)))));
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement("span", {
          id: this.generateId(ERROR_TITLE_ID)
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.errorTitle",
          defaultMessage: "Some fields require your attention."
        })),
        color: "danger",
        iconType: "error"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, null, messagesToBeRendered), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        "data-test-subj": "remoteClusterFormGlobalError"
      }));
    });
    const {
      cluster: _cluster
    } = props;
    const {
      isCloudEnabled: _isCloudEnabled
    } = context;

    // Connection mode should default to "proxy" in cloud
    const defaultMode = _isCloudEnabled ? _constants.PROXY_MODE : _constants.SNIFF_MODE;
    const fieldsState = (0, _lodash.merge)({}, {
      ...defaultClusterValues,
      mode: defaultMode,
      cloudUrl: (0, _validators.convertProxyConnectionToCloudUrl)(_cluster),
      cloudUrlEnabled: _isCloudEnabled && (0, _validators.isCloudUrlEnabled)(_cluster)
    }, _cluster);
    this.generateId = (0, _eui.htmlIdGenerator)();
    this.state = {
      fields: fieldsState,
      fieldsErrors: (0, _validators.validateCluster)(fieldsState, _isCloudEnabled),
      areErrorsVisible: false,
      isRequestVisible: false
    };
  }
  getCluster() {
    const {
      fields: {
        name,
        mode,
        seeds,
        nodeConnections,
        proxyAddress,
        proxySocketConnections,
        serverName,
        skipUnavailable
      }
    } = this.state;
    const {
      cluster
    } = this.props;
    let modeSettings;
    if (mode === _constants.PROXY_MODE) {
      modeSettings = {
        proxyAddress,
        proxySocketConnections,
        serverName
      };
    } else {
      modeSettings = {
        seeds,
        nodeConnections
      };
    }
    return {
      name,
      skipUnavailable,
      mode,
      hasDeprecatedProxySetting: cluster === null || cluster === void 0 ? void 0 : cluster.hasDeprecatedProxySetting,
      ...modeSettings
    };
  }
  renderSkipUnavailable() {
    const {
      fields: {
        skipUnavailable
      }
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableTitle",
        defaultMessage: "Make remote cluster optional"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableDescription",
        defaultMessage: "If any of the remote clusters are unavailable, the query request fails. To avoid this and continue to send requests to other clusters, enable {optionName}. {learnMoreLink}",
        values: {
          optionName: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableDescription.optionNameLabel",
            defaultMessage: "Skip if unavailable"
          })),
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.skippingDisconnectedClustersUrl,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableDescription.learnMoreLinkLabel",
            defaultMessage: "Learn more."
          }))
        }
      }))),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "remoteClusterFormSkipUnavailableFormRow",
      className: "remoteClusterSkipIfUnavailableSwitch",
      hasEmptyLabelSpace: true,
      fullWidth: true,
      helpText: skipUnavailable !== defaultClusterValues.skipUnavailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => {
          this.resetToDefault('skipUnavailable');
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableResetLabel",
        defaultMessage: "Reset to default"
      })) : null
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableLabel', {
        defaultMessage: 'Skip if unavailable'
      }),
      checked: !!skipUnavailable,
      onChange: this.onSkipUnavailableChange,
      "data-test-subj": "remoteClusterFormSkipUnavailableFormToggle"
    })));
  }
  renderActions() {
    const {
      isSaving,
      cancel,
      cluster: isEditMode
    } = this.props;
    const {
      areErrorsVisible,
      isRequestVisible
    } = this.state;
    const isSaveDisabled = areErrorsVisible && this.hasErrors() || isSaving;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, cancel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      onClick: cancel
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cancelButtonLabel",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.toggleRequest,
      "data-test-subj": "remoteClustersRequestButton"
    }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.hideRequestButtonLabel",
      defaultMessage: "Hide request"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.showRequestButtonLabel",
      defaultMessage: "Show request"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "remoteClusterFormSaveButton",
      color: "primary",
      onClick: this.save,
      fill: true,
      isDisabled: isSaveDisabled,
      isLoading: isSaving,
      "aria-describedby": `${this.generateId(ERROR_TITLE_ID)} ${this.generateId(ERROR_LIST_ID)}`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.nextButtonLabel",
      defaultMessage: "{isEditMode, select, true{Save} other{Next}}",
      values: {
        isEditMode: Boolean(isEditMode)
      }
    }))))));
  }
  renderSavingFeedback() {
    if (this.props.isSaving) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoKibana",
        size: "xl"
      }));
    }
    return null;
  }
  renderSaveErrorFeedback() {
    const {
      saveError
    } = this.props;
    if (saveError) {
      const {
        message,
        cause
      } = saveError;
      let errorBody;
      if (cause && Array.isArray(cause)) {
        if (cause.length === 1) {
          errorBody = /*#__PURE__*/_react.default.createElement("p", null, cause[0]);
        } else {
          errorBody = /*#__PURE__*/_react.default.createElement("ul", null, cause.map(causeValue => /*#__PURE__*/_react.default.createElement("li", {
            key: causeValue
          }, causeValue)));
        }
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: message,
        iconType: "cross",
        color: "warning"
      }, errorBody), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
    }
    return null;
  }
  render() {
    const {
      isRequestVisible,
      areErrorsVisible,
      fields,
      fieldsErrors
    } = this.state;
    const {
      name: errorClusterName
    } = fieldsErrors;
    const {
      cluster
    } = this.props;
    const isNew = !cluster;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.renderSaveErrorFeedback(), this.renderErrors(), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      "data-test-subj": "remoteClusterForm"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionNameTitle",
        defaultMessage: "Name"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionNameDescription",
        defaultMessage: "A unique name for the cluster."
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "remoteClusterFormNameFormRow",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.fieldNameLabel",
        defaultMessage: "Name"
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.fieldNameLabelHelpText",
        defaultMessage: "Must contain only letters, numbers, underscores, and dashes."
      }),
      error: errorClusterName,
      isInvalid: Boolean(areErrorsVisible && errorClusterName),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: Boolean(areErrorsVisible && errorClusterName),
      value: fields.name,
      onChange: e => this.onFieldsChange({
        name: e.target.value
      }),
      fullWidth: true,
      disabled: !isNew,
      "data-test-subj": "remoteClusterFormNameInput"
    }))), /*#__PURE__*/_react.default.createElement(_components.ConnectionMode, {
      fields: fields,
      fieldsErrors: fieldsErrors,
      onFieldsChange: this.onFieldsChange,
      areErrorsVisible: areErrorsVisible
    }), this.renderSkipUnavailable()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), this.renderActions(), this.renderSavingFeedback(), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
      cluster: this.getCluster(),
      close: () => this.setState({
        isRequestVisible: false
      })
    }) : null);
  }
}
exports.RemoteClusterForm = RemoteClusterForm;
(0, _defineProperty2.default)(RemoteClusterForm, "defaultProps", {
  fields: (0, _lodash.merge)({}, defaultClusterValues)
});
(0, _defineProperty2.default)(RemoteClusterForm, "contextType", _app_context.AppContext);