"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SniffConnection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../services/documentation");
var _validators = require("../validators");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SniffConnection = ({
  fields,
  fieldsErrors,
  areErrorsVisible,
  onFieldsChange
}) => {
  const [localSeedErrors, setLocalSeedErrors] = (0, _react.useState)([]);
  const {
    seeds = [],
    nodeConnections
  } = fields;
  const {
    seeds: seedsError
  } = fieldsErrors;
  // Show errors if there is a general form error or local errors.
  const areFormErrorsVisible = Boolean(areErrorsVisible && seedsError);
  const showErrors = areFormErrorsVisible || localSeedErrors.length !== 0;
  const errors = areFormErrorsVisible && seedsError ? localSeedErrors.concat(seedsError) : localSeedErrors;
  const formattedSeeds = seeds.map(seed => ({
    label: seed
  }));
  const onCreateSeed = newSeed => {
    // If the user just hit enter without typing anything, treat it as a no-op.
    if (!newSeed) {
      return;
    }
    const validationErrors = (0, _validators.validateSeed)(newSeed);
    if (validationErrors.length !== 0) {
      setLocalSeedErrors(validationErrors);
      // Return false to explicitly reject the user's input.
      return false;
    }
    const newSeeds = seeds.slice(0);
    newSeeds.push(newSeed.toLowerCase());
    onFieldsChange({
      seeds: newSeeds
    });
  };
  const onSeedsInputChange = seedInput => {
    if (!seedInput) {
      // If empty seedInput ("") don't do anything. This happens
      // right after a seed is created.
      return;
    }

    // Allow typing to clear the errors, but not to add new ones.
    const validationErrors = !seedInput || (0, _validators.validateSeed)(seedInput).length === 0 ? [] : localSeedErrors;

    // EuiComboBox internally checks for duplicates and prevents calling onCreateOption if the
    // input is a duplicate. So we need to surface this error here instead.
    const isDuplicate = seeds.includes(seedInput);
    if (isDuplicate) {
      validationErrors.push( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.localSeedError.duplicateMessage",
        defaultMessage: "Duplicate seed nodes aren't allowed.`"
      }));
    }
    setLocalSeedErrors(validationErrors);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormSeedNodesFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSeedsLabel",
      defaultMessage: "Seed nodes"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSeedsHelpText",
      defaultMessage: "An IP address or host name, followed by the {transportPort} of the remote cluster. Specify multiple seed nodes so discovery doesn't fail if a node is unavailable.",
      values: {
        transportPort: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.transportPortUrl,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.sectionSeedsHelpText.portLinkText",
          defaultMessage: "port"
        }))
      }
    }),
    isInvalid: showErrors,
    error: errors,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.fieldSeedsPlaceholder', {
      defaultMessage: 'host:port'
    }),
    selectedOptions: formattedSeeds,
    onCreateOption: onCreateSeed,
    onChange: options => onFieldsChange({
      seeds: options.map(({
        label
      }) => label)
    }),
    onSearchChange: onSeedsInputChange,
    isInvalid: showErrors,
    fullWidth: true,
    "data-test-subj": "remoteClusterFormSeedsInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormNodeConnectionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNodeConnectionsLabel",
      defaultMessage: "Node connections"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNodeConnectionsHelpText",
      defaultMessage: "The number of gateway nodes to connect to for this cluster."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: nodeConnections || '',
    onChange: e => onFieldsChange({
      nodeConnections: Number(e.target.value)
    }),
    fullWidth: true
  })));
};
exports.SniffConnection = SniffConnection;