"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTopNFunctionsSearchRoute = registerTopNFunctionsSearchRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require(".");
var _common = require("../../common");
var _handle_route_error_handler = require("../utils/handle_route_error_handler");
var _compat = require("./compat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const querySchema = _configSchema.schema.object({
  timeFrom: _configSchema.schema.number(),
  timeTo: _configSchema.schema.number(),
  startIndex: _configSchema.schema.number(),
  endIndex: _configSchema.schema.number(),
  kuery: _configSchema.schema.string()
});
function registerTopNFunctionsSearchRoute({
  router,
  logger,
  dependencies: {
    start: {
      profilingDataAccess
    }
  }
}) {
  const paths = (0, _common.getRoutePaths)();
  router.get({
    path: paths.TopNFunctions,
    options: {
      tags: ['access:profiling'],
      timeout: {
        idleSocket: _.IDLE_SOCKET_TIMEOUT
      }
    },
    validate: {
      query: querySchema
    }
  }, async (context, request, response) => {
    try {
      const core = await context.core;
      const {
        timeFrom,
        timeTo,
        startIndex,
        endIndex,
        kuery
      } = request.query;
      const esClient = await (0, _compat.getClient)(context);
      const topNFunctions = await profilingDataAccess.services.fetchFunction({
        core,
        esClient,
        rangeFromMs: timeFrom,
        rangeToMs: timeTo,
        kuery,
        startIndex,
        endIndex
      });
      return response.ok({
        body: topNFunctions
      });
    } catch (error) {
      return (0, _handle_route_error_handler.handleRouteHandlerError)({
        error,
        logger,
        response,
        message: 'Error while fetching TopN functions'
      });
    }
  });
}