"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageDetailsTable = StorageDetailsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _common2 = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sorting = {
  sort: {
    field: 'sizeInBytes',
    direction: 'desc'
  }
};
function StorageDetailsTable({
  data = []
}) {
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  function onTableChange({
    page: {
      index
    }
  }) {
    setPagination({
      pageIndex: index
    });
  }
  const columns = (0, _react.useMemo)(() => [{
    field: 'indexName',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.index', {
      defaultMessage: 'Index'
    }),
    sortable: true
  }, {
    field: 'primaryShardsCount',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.primaries', {
      defaultMessage: 'Primaries'
    }),
    render: (_, {
      primaryShardsCount
    }) => primaryShardsCount !== null && primaryShardsCount !== void 0 ? primaryShardsCount : _common2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    field: 'replicaShardsCount',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.replicas', {
      defaultMessage: 'Replicas'
    }),
    render: (_, {
      replicaShardsCount
    }) => replicaShardsCount !== null && replicaShardsCount !== void 0 ? replicaShardsCount : _common2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    field: 'docCount',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.docCount', {
      defaultMessage: 'Doc count'
    }),
    sortable: true,
    render: (_, {
      docCount
    }) => docCount ? (0, _common.asInteger)(docCount) : _common2.NOT_AVAILABLE_LABEL
  }, {
    field: 'sizeInBytes',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.storageSize', {
      defaultMessage: 'Storage size'
    }),
    sortable: true,
    render: (_, {
      sizeInBytes
    }) => sizeInBytes ? (0, _common.asDynamicBytes)(sizeInBytes) : _common2.NOT_AVAILABLE_LABEL
  }, {
    field: 'dataStream',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.dataStream', {
      defaultMessage: 'Data stream'
    }),
    sortable: true,
    render: (_, {
      dataStream
    }) => dataStream !== null && dataStream !== void 0 ? dataStream : _common2.NOT_AVAILABLE_LABEL
  }, {
    field: 'lifecyclePhase',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.lifecyclePhase', {
      defaultMessage: 'Lifecycle phase'
    }),
    sortable: true,
    render: (_, {
      lifecyclePhase
    }) => lifecyclePhase !== null && lifecyclePhase !== void 0 ? lifecyclePhase : _common2.NOT_AVAILABLE_LABEL
  }], []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.title', {
    defaultMessage: 'Indices breakdown'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: data,
    columns: columns,
    sorting: sorting,
    pagination: {
      pageSize: 10,
      showPerPageOptions: false,
      ...pagination
    },
    onTableChange: onTableChange
  }));
}