"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphView = FlameGraphView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _flamegraph = require("../../../components/flamegraph");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraphView() {
  const {
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      searchText
    }
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/flamegraph');
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchElasticFlamechart
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchElasticFlamechart({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      kuery
    });
  }, [fetchElasticFlamechart, timeRange.start, timeRange.end, kuery]);
  const {
    data
  } = state;
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function handleSearchTextChange(newSearchText) {
    // @ts-expect-error Code gets too complicated to satisfy TS constraints
    profilingRouter.push(routePath, {
      query: {
        ...query,
        searchText: newSearchText
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    style: {
      height: '100%'
    },
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraph, {
    id: "flamechart",
    primaryFlamegraph: data,
    searchText: searchText,
    onChangeSearchText: handleSearchTextChange
  }))));
}