"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profilingRouter = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _profilingUtils = require("@kbn/profiling-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _storage_explorer = require("../../common/storage_explorer");
var _normalization_menu = require("../components/normalization_menu");
var _redirect_to = require("../components/redirect_to");
var _add_data_view = require("../views/add_data_view");
var _delete_data_view = require("../views/delete_data_view");
var _flamegraphs = require("../views/flamegraphs");
var _differential_flamegraphs = require("../views/flamegraphs/differential_flamegraphs");
var _flamegraph = require("../views/flamegraphs/flamegraph");
var _functions = require("../views/functions");
var _differential_topn = require("../views/functions/differential_topn");
var _topn = require("../views/functions/topn");
var _settings = require("../views/settings");
var _stack_traces_view = require("../views/stack_traces_view");
var _storage_explorer2 = require("../views/storage_explorer");
var _route_breadcrumb = require("./route_breadcrumb");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
      title: _i18n.i18n.translate('xpack.profiling.breadcrumb.profiling', {
        defaultMessage: 'Universal Profiling'
      }),
      href: "/"
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    children: {
      '/settings': {
        element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
          title: _i18n.i18n.translate('xpack.profiling.breadcrumb.settings', {
            defaultMessage: 'Settings'
          }),
          href: "/settings"
        }, /*#__PURE__*/_react.default.createElement(_settings.Settings, null))
      },
      '/add-data-instructions': {
        element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
          title: _i18n.i18n.translate('xpack.profiling.breadcrumb.addDataView', {
            defaultMessage: 'Add profiling data'
          }),
          href: "/add-data-instructions"
        }, /*#__PURE__*/_react.default.createElement(_add_data_view.AddDataView, null)),
        params: t.type({
          query: t.type({
            selectedTab: t.union([t.literal(_add_data_view.AddDataTabs.Binary), t.literal(_add_data_view.AddDataTabs.Deb), t.literal(_add_data_view.AddDataTabs.Docker), t.literal(_add_data_view.AddDataTabs.ElasticAgentIntegration), t.literal(_add_data_view.AddDataTabs.Kubernetes), t.literal(_add_data_view.AddDataTabs.RPM), t.literal(_add_data_view.AddDataTabs.Symbols)])
          })
        }),
        defaults: {
          query: {
            selectedTab: _add_data_view.AddDataTabs.Kubernetes
          }
        }
      },
      '/delete_data_instructions': {
        element: /*#__PURE__*/_react.default.createElement(_delete_data_view.DeleteDataView, null)
      },
      '/': {
        children: {
          '/stacktraces/{topNType}': {
            element: /*#__PURE__*/_react.default.createElement(_stack_traces_view.StackTracesView, null),
            params: t.type({
              path: t.type({
                topNType: t.union([t.literal(_profilingUtils.TopNType.Containers), t.literal(_profilingUtils.TopNType.Deployments), t.literal(_profilingUtils.TopNType.Hosts), t.literal(_profilingUtils.TopNType.Threads), t.literal(_profilingUtils.TopNType.Traces)])
              }),
              query: t.type({
                displayAs: t.union([t.literal(_profilingUtils.StackTracesDisplayOption.StackTraces), t.literal(_profilingUtils.StackTracesDisplayOption.Percentage)]),
                limit: _ioTsUtils.toNumberRt
              })
            }),
            defaults: {
              query: {
                displayAs: _profilingUtils.StackTracesDisplayOption.StackTraces,
                limit: '10'
              }
            }
          },
          '/stacktraces': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              pathname: "/stacktraces/threads"
            })
          },
          '/flamegraphs': {
            element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
              title: _i18n.i18n.translate('xpack.profiling.breadcrumb.flamegraphs', {
                defaultMessage: 'Flamegraphs'
              }),
              href: "/flamegraphs/flamegraph"
            }, /*#__PURE__*/_react.default.createElement(_flamegraphs.FlameGraphsView, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))),
            children: {
              '/flamegraphs/flamegraph': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.flamegraph', {
                    defaultMessage: 'Flamegraph'
                  }),
                  href: "/flamegraphs/flamegraph"
                }, /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraphView, null)),
                params: t.type({
                  query: t.partial({
                    searchText: t.string
                  })
                })
              },
              '/flamegraphs/differential': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.differentialFlamegraph', {
                    defaultMessage: 'Differential flamegraph'
                  }),
                  href: "/flamegraphs/differential"
                }, /*#__PURE__*/_react.default.createElement(_differential_flamegraphs.DifferentialFlameGraphsView, null)),
                params: t.type({
                  query: t.intersection([t.type({
                    comparisonRangeFrom: t.string,
                    comparisonRangeTo: t.string,
                    comparisonKuery: t.string,
                    comparisonMode: t.union([t.literal(_normalization_menu.ComparisonMode.Absolute), t.literal(_normalization_menu.ComparisonMode.Relative)]),
                    normalizationMode: t.union([t.literal(_normalization_menu.NormalizationMode.Scale), t.literal(_normalization_menu.NormalizationMode.Time)])
                  }), t.partial({
                    baseline: _ioTsUtils.toNumberRt,
                    comparison: _ioTsUtils.toNumberRt,
                    searchText: t.string
                  })])
                }),
                defaults: {
                  query: {
                    comparisonRangeFrom: 'now-15m',
                    comparisonRangeTo: 'now',
                    comparisonKuery: '',
                    comparisonMode: _normalization_menu.ComparisonMode.Absolute,
                    normalizationMode: _normalization_menu.NormalizationMode.Time
                  }
                }
              }
            }
          },
          '/functions': {
            element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
              title: _i18n.i18n.translate('xpack.profiling.breadcrumb.functions', {
                defaultMessage: 'Functions'
              }),
              href: "/functions/topn"
            }, /*#__PURE__*/_react.default.createElement(_functions.FunctionsView, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))),
            params: t.type({
              query: t.type({
                sortField: _profilingUtils.topNFunctionSortFieldRt,
                sortDirection: t.union([t.literal('asc'), t.literal('desc')])
              })
            }),
            defaults: {
              query: {
                sortField: _profilingUtils.TopNFunctionSortField.Rank,
                sortDirection: 'asc'
              }
            },
            children: {
              '/functions/topn': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.topnFunctions', {
                    defaultMessage: 'Top N'
                  }),
                  href: "/functions/topn"
                }, /*#__PURE__*/_react.default.createElement(_topn.TopNFunctionsView, null)),
                params: t.type({
                  query: t.partial({
                    pageIndex: _ioTsUtils.toNumberRt
                  })
                })
              },
              '/functions/differential': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.differentialFunctions', {
                    defaultMessage: 'Differential Top N'
                  }),
                  href: "/functions/differential"
                }, /*#__PURE__*/_react.default.createElement(_differential_topn.DifferentialTopNFunctionsView, null)),
                params: t.type({
                  query: t.intersection([t.type({
                    comparisonRangeFrom: t.string,
                    comparisonRangeTo: t.string,
                    comparisonKuery: t.string,
                    normalizationMode: t.union([t.literal(_normalization_menu.NormalizationMode.Scale), t.literal(_normalization_menu.NormalizationMode.Time)]),
                    comparisonSortField: _profilingUtils.topNComparisonFunctionSortFieldRt,
                    comparisonSortDirection: t.union([t.literal('asc'), t.literal('desc')])
                  }), t.partial({
                    baseline: _ioTsUtils.toNumberRt,
                    comparison: _ioTsUtils.toNumberRt,
                    pageIndex: _ioTsUtils.toNumberRt
                  })])
                }),
                defaults: {
                  query: {
                    comparisonRangeFrom: 'now-15m',
                    comparisonRangeTo: 'now',
                    comparisonKuery: '',
                    normalizationMode: _normalization_menu.NormalizationMode.Time,
                    comparisonSortField: _profilingUtils.TopNComparisonFunctionSortField.ComparisonRank,
                    comparisonSortDirection: 'asc'
                  }
                }
              }
            }
          },
          '/storage-explorer': {
            element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
              title: _i18n.i18n.translate('xpack.profiling.breadcrumb.storageExplorer', {
                defaultMessage: 'Storage explorer'
              }),
              href: "/storage-explorer"
            }, /*#__PURE__*/_react.default.createElement(_storage_explorer2.StorageExplorerView, null)),
            params: t.type({
              query: _storage_explorer.indexLifecyclePhaseRt
            }),
            defaults: {
              query: {
                indexLifecyclePhase: _storage_explorer.IndexLifecyclePhaseSelectOption.All
              }
            }
          },
          '/': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              pathname: "/stacktraces/threads"
            })
          }
        },
        element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
        params: t.type({
          query: t.type({
            rangeFrom: t.string,
            rangeTo: t.string,
            kuery: t.string
          })
        }),
        defaults: {
          query: {
            kuery: ''
          }
        }
      }
    }
  }
};
const profilingRouter = (0, _typedReactRouterConfig.createRouter)(routes);
exports.profilingRouter = profilingRouter;