"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingEmbeddableProvider = ProfilingEmbeddableProvider;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _profiling_dependencies_context = require("../components/contexts/profiling_dependencies/profiling_dependencies_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storage = new _public2.Storage(localStorage);
function ProfilingEmbeddableProvider({
  deps,
  children
}) {
  const profilingDependencies = (0, _react.useMemo)(() => ({
    start: {
      core: deps.coreStart,
      ...deps.pluginsStart
    },
    setup: {
      core: deps.coreSetup,
      ...deps.pluginsSetup
    },
    services: deps.profilingFetchServices
  }), [deps]);
  const i18nCore = deps.coreStart.i18n;
  return /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...deps.coreStart,
      ...deps.pluginsStart,
      storage
    }
  }, /*#__PURE__*/_react.default.createElement(_profiling_dependencies_context.ProfilingDependenciesContextProvider, {
    value: profilingDependencies
  }, children)));
}