"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFlamegraph = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _flamegraph = require("../../components/flamegraph");
var _async_embeddable_component = require("../async_embeddable_component");
var _profiling_embeddable_provider = require("../profiling_embeddable_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableFlamegraph extends _public.Embeddable {
  constructor(deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", _public2.EMBEDDABLE_FLAMEGRAPH);
    (0, _defineProperty2.default)(this, "_domNode", void 0);
    this.deps = deps;
  }
  render(domNode) {
    this._domNode = domNode;
    const {
      data,
      isLoading
    } = this.input;
    const flamegraph = !isLoading && data ? (0, _profilingUtils.createFlameGraph)(data) : undefined;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_profiling_embeddable_provider.ProfilingEmbeddableProvider, {
      deps: this.deps
    }, /*#__PURE__*/_react.default.createElement(_async_embeddable_component.AsyncEmbeddableComponent, {
      isLoading: isLoading
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flamegraph && /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraph, {
      primaryFlamegraph: flamegraph,
      id: "embddable_profiling",
      isEmbedded: true
    })))), domNode);
  }
  destroy() {
    if (this._domNode) {
      (0, _reactDom.unmountComponentAtNode)(this._domNode);
    }
  }
  reload() {
    if (this._domNode) {
      this.render(this._domNode);
    }
  }
}
exports.EmbeddableFlamegraph = EmbeddableFlamegraph;