"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrameInformationWindow = FrameInformationWindow;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _frame_information_ai_assistant = require("./frame_information_ai_assistant");
var _frame_information_panel = require("./frame_information_panel");
var _get_impact_rows = require("./get_impact_rows");
var _get_information_rows = require("./get_information_rows");
var _key_value_list = require("./key_value_list");
var _missing_symbols_callout = require("./missing_symbols_callout");
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FrameInformationWindow({
  frame,
  totalSamples,
  totalSeconds,
  showSymbolsStatus = true
}) {
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  const {
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const shouldUseLegacyCo2Calculation = core.uiSettings.get(_common.profilingUseLegacyCo2Calculation);
  if (!frame) {
    return /*#__PURE__*/_react.default.createElement(_frame_information_panel.FrameInformationPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.selectFrame', {
      defaultMessage: 'Click on a frame to display more information'
    })));
  }
  const symbolStatus = (0, _profilingUtils.getFrameSymbolStatus)({
    sourceFilename: frame.sourceFileName,
    sourceLine: frame.sourceLine,
    exeFileName: frame.exeFileName
  });
  const {
    fileID,
    frameType,
    exeFileName,
    addressOrLine,
    functionName,
    sourceFileName,
    sourceLine,
    countInclusive,
    countExclusive,
    selfAnnualCO2Kgs,
    totalAnnualCO2Kgs,
    selfAnnualCostUSD,
    totalAnnualCostUSD
  } = frame;
  const informationRows = (0, _get_information_rows.getInformationRows)({
    fileID,
    frameType,
    exeFileName,
    addressOrLine,
    functionName,
    sourceFileName,
    sourceLine
  });
  const impactRows = (0, _get_impact_rows.getImpactRows)({
    countInclusive,
    countExclusive,
    totalSamples,
    totalSeconds,
    calculateImpactEstimates,
    shouldUseLegacyCo2Calculation,
    selfAnnualCO2Kgs,
    totalAnnualCO2Kgs,
    selfAnnualCostUSD,
    totalAnnualCostUSD
  });
  return /*#__PURE__*/_react.default.createElement(_frame_information_panel.FrameInformationPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_key_value_list.KeyValueList, {
    "data-test-subj": "informationRows",
    rows: informationRows
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_frame_information_ai_assistant.FrameInformationAIAssistant, {
    frame: frame
  })), showSymbolsStatus && symbolStatus !== _profilingUtils.FrameSymbolStatus.SYMBOLIZED ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_missing_symbols_callout.MissingSymbolsCallout, {
    frameType: frame.frameType
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.impactEstimatesTitle', {
    defaultMessage: 'Impact estimates'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_key_value_list.KeyValueList, {
    "data-test-subj": "impactEstimates",
    rows: impactRows
  }))))));
}