"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphLegend = FlameGraphLegend;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _legend = require("../legend");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraphLegend({
  legendItems,
  asScale
}) {
  if (asScale) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      size: "s"
    }, _i18n.i18n.translate('xpack.profiling.flameGraphLegend.improvement', {
      defaultMessage: 'Improvement'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      size: "s"
    }, _i18n.i18n.translate('xpack.profiling.flameGraphLegend.regression', {
      defaultMessage: 'Regression'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, "+", (0, _as_percentage.asPercentage)(1))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: legendItems.length * 20
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "none"
    }, legendItems.map(({
      color,
      label
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: label,
        style: {
          backgroundColor: color,
          justifyContent: 'center'
        }
      }, label ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        style: {
          verticalAlign: 'center',
          whiteSpace: 'nowrap',
          paddingLeft: 8,
          paddingRight: 8
        }
      }, label) : '');
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _as_percentage.asPercentage)(-1))))))))));
  }
  return /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    legendItems: legendItems
  });
}