"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeContext = void 0;
exports.TimeRangeContextProvider = TimeRangeContextProvider;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeRangeContext = /*#__PURE__*/_react.default.createContext(undefined);
exports.TimeRangeContext = TimeRangeContext;
function TimeRangeContextProvider({
  children
}) {
  const [timeRangeId, setTimeRangeId] = (0, _react.useState)((0, _lodash.uniqueId)());
  const timeRangeContextValue = (0, _react.useMemo)(() => {
    return {
      timeRangeId,
      refresh: () => {
        setTimeRangeId((0, _lodash.uniqueId)());
      }
    };
  }, [timeRangeId]);
  return /*#__PURE__*/_react.default.createElement(TimeRangeContext.Provider, {
    value: timeRangeContextValue
  }, children);
}