"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerServices = registerServices;
var _fetch_flamechart = require("./fetch_flamechart");
var _status = require("./status");
var _functions = require("./functions");
var _setup_state = require("./setup_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerServices(params) {
  return {
    fetchFlamechartData: (0, _fetch_flamechart.createFetchFlamechart)(params),
    getStatus: (0, _status.createGetStatusService)(params),
    getSetupState: (0, _setup_state.createSetupState)(params),
    fetchFunction: (0, _functions.createFetchFunctions)(params)
  };
}