"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchFunctions = createFetchFunctions;
var _common = require("@kbn/observability-plugin/common");
var _profilingUtils = require("@kbn/profiling-utils");
var _percent_to_factor = require("../../utils/percent_to_factor");
var _with_profiling_span = require("../../utils/with_profiling_span");
var _search_stack_traces = require("../search_stack_traces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const targetSampleSize = 20000; // minimum number of samples to get statistically sound results

function createFetchFunctions({
  createProfilingEsClient
}) {
  return async ({
    core,
    esClient,
    rangeFromMs,
    rangeToMs,
    kuery,
    startIndex,
    endIndex
  }) => {
    const rangeFromSecs = rangeFromMs / 1000;
    const rangeToSecs = rangeToMs / 1000;
    const totalSeconds = rangeToSecs - rangeFromSecs;
    const [co2PerKWH, datacenterPUE, pervCPUWattX86, pervCPUWattArm64, awsCostDiscountRate, costPervCPUPerHour] = await Promise.all([core.uiSettings.client.get(_common.profilingCo2PerKWH), core.uiSettings.client.get(_common.profilingDatacenterPUE), core.uiSettings.client.get(_common.profilingPervCPUWattX86), core.uiSettings.client.get(_common.profilingPervCPUWattArm64), core.uiSettings.client.get(_common.profilingAWSCostDiscountRate), core.uiSettings.client.get(_common.profilingCostPervCPUPerHour)]);
    const profilingEsClient = createProfilingEsClient({
      esClient
    });
    const {
      events,
      stackTraces,
      executables,
      stackFrames,
      samplingRate
    } = await (0, _search_stack_traces.searchStackTraces)({
      client: profilingEsClient,
      rangeFrom: rangeFromSecs,
      rangeTo: rangeToSecs,
      kuery,
      sampleSize: targetSampleSize,
      durationSeconds: totalSeconds,
      co2PerKWH,
      datacenterPUE,
      pervCPUWattX86,
      pervCPUWattArm64,
      awsCostDiscountRate: (0, _percent_to_factor.percentToFactor)(awsCostDiscountRate),
      costPervCPUPerHour
    });
    const topNFunctions = await (0, _with_profiling_span.withProfilingSpan)('create_topn_functions', async () => {
      return (0, _profilingUtils.createTopNFunctions)({
        endIndex,
        events,
        executables,
        samplingRate,
        stackFrames,
        stackTraces,
        startIndex
      });
    });
    return topNFunctions;
  };
}