"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReduxEmbeddableTools = void 0;
var _create_redux_tools = require("../create_redux_tools");
var _sync_redux_embeddable = require("./sync_redux_embeddable");
var _clean_redux_embeddable_state = require("./clean_redux_embeddable_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createReduxEmbeddableTools = ({
  reducers,
  embeddable,
  syncSettings,
  additionalMiddleware,
  initialComponentState
}) => {
  /**
   * Build additional generic reducers to aid in embeddable syncing.
   */
  const genericReducers = {
    replaceEmbeddableReduxInput: (state, action) => {
      state.explicitInput = action.payload;
    },
    replaceEmbeddableReduxOutput: (state, action) => {
      state.output = action.payload;
    }
  };
  const allReducers = {
    ...reducers,
    ...genericReducers
  };

  /**
   * Create initial state from Embeddable.
   */
  let initialState = {
    output: embeddable.getOutput(),
    componentState: initialComponentState !== null && initialComponentState !== void 0 ? initialComponentState : {},
    explicitInput: embeddable.getExplicitInput()
  };
  initialState = (0, _clean_redux_embeddable_state.cleanStateForRedux)(initialState);
  const {
    dispatch,
    store,
    select,
    getState,
    onStateChange
  } = (0, _create_redux_tools.createReduxTools)({
    reducers: allReducers,
    additionalMiddleware,
    initialState
  });

  /**
   * Sync redux state with embeddable input and output observables. Eventually we can replace the input and output observables
   * with redux and remove this sync.
   */
  const stopReduxEmbeddableSync = (0, _sync_redux_embeddable.syncReduxEmbeddable)({
    replaceEmbeddableReduxInput: dispatch.replaceEmbeddableReduxInput,
    replaceEmbeddableReduxOutput: dispatch.replaceEmbeddableReduxOutput,
    settings: syncSettings,
    embeddable,
    store
  });
  return {
    store,
    select,
    dispatch,
    getState,
    onStateChange,
    cleanup: () => stopReduxEmbeddableSync === null || stopReduxEmbeddableSync === void 0 ? void 0 : stopReduxEmbeddableSync()
  };
};
exports.createReduxEmbeddableTools = createReduxEmbeddableTools;