"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionHandler = void 0;
var _uuid = require("uuid");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _create_queries = require("./create_queries");
var _utils = require("../../routes/utils");
var _parse_agent_groups = require("../../lib/parse_agent_groups");
var _types = require("../../../common/types");
var _utils2 = require("../../routes/pack/utils");
var _constants = require("../../../common/constants");
var _constants2 = require("../../lib/telemetry/constants");
var _error = require("../../common/error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createActionHandler = async (osqueryContext, params, options) => {
  var _packSO, _packSO$attributes, _packSO2;
  const [coreStartServices] = await osqueryContext.getStartServices();
  const esClientInternal = coreStartServices.elasticsearch.client.asInternalUser;
  const internalSavedObjectsClient = await (0, _utils.getInternalSavedObjectsClient)(osqueryContext.getStartServices);
  const {
    soClient,
    metadata,
    alertData,
    error
  } = options;
  const savedObjectsClient = soClient !== null && soClient !== void 0 ? soClient : coreStartServices.savedObjects.createInternalRepository();
  const elasticsearchClient = coreStartServices.elasticsearch.client.asInternalUser;
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    agent_all,
    agent_ids,
    agent_platforms,
    agent_policy_ids
  } = params;
  const selectedAgents = await (0, _parse_agent_groups.parseAgentSelection)(internalSavedObjectsClient, elasticsearchClient, osqueryContext, {
    agents: agent_ids,
    allAgentsSelected: !!agent_all,
    platformsSelected: agent_platforms,
    policiesSelected: agent_policy_ids
  });
  if (!selectedAgents.length) {
    throw new _error.CustomHttpRequestError('No agents found for selection', 400);
  }
  let packSO;
  if (params.pack_id) {
    packSO = await savedObjectsClient.get(_types.packSavedObjectType, params.pack_id);
  }
  const osqueryAction = {
    action_id: (0, _uuid.v4)(),
    '@timestamp': (0, _moment.default)().toISOString(),
    expiration: (0, _moment.default)().add(5, 'minutes').toISOString(),
    type: 'INPUT_ACTION',
    input_type: 'osquery',
    alert_ids: params.alert_ids,
    event_ids: params.event_ids,
    case_ids: params.case_ids,
    agent_ids: params.agent_ids,
    agent_all: params.agent_all,
    agent_platforms: params.agent_platforms,
    agent_policy_ids: params.agent_policy_ids,
    agents: selectedAgents,
    user_id: metadata === null || metadata === void 0 ? void 0 : metadata.currentUser,
    metadata: params.metadata,
    pack_id: params.pack_id,
    pack_name: (_packSO = packSO) === null || _packSO === void 0 ? void 0 : (_packSO$attributes = _packSO.attributes) === null || _packSO$attributes === void 0 ? void 0 : _packSO$attributes.name,
    pack_prebuilt: params.pack_id ? (0, _lodash.some)((_packSO2 = packSO) === null || _packSO2 === void 0 ? void 0 : _packSO2.references, ['type', 'osquery-pack-asset']) : undefined,
    queries: packSO ? (0, _lodash.map)((0, _utils2.convertSOQueriesToPack)(packSO.attributes.queries), (packQuery, packQueryId) => {
      const replacedQuery = (0, _create_queries.replacedQueries)(packQuery.query, alertData);
      return (0, _lodash.pickBy)({
        action_id: (0, _uuid.v4)(),
        id: packQueryId,
        ...replacedQuery,
        ...(error ? {
          error
        } : {}),
        ecs_mapping: packQuery.ecs_mapping,
        version: packQuery.version,
        platform: packQuery.platform,
        timeout: packQuery.timeout,
        agents: selectedAgents
      }, value => !(0, _lodash.isEmpty)(value) || (0, _lodash.isNumber)(value));
    }) : await (0, _create_queries.createDynamicQueries)({
      params,
      alertData,
      agents: selectedAgents,
      osqueryContext,
      error
    })
  };
  const fleetActions = !error ? (0, _lodash.map)((0, _lodash.filter)(osqueryAction.queries, query => !query.error), query => ({
    action_id: query.action_id,
    '@timestamp': (0, _moment.default)().toISOString(),
    expiration: (0, _moment.default)().add(5, 'minutes').toISOString(),
    type: 'INPUT_ACTION',
    input_type: 'osquery',
    agents: query.agents,
    user_id: metadata === null || metadata === void 0 ? void 0 : metadata.currentUser,
    ...(query.timeout !== _constants.QUERY_TIMEOUT.DEFAULT ? {
      timeout: query.timeout
    } : {}),
    data: (0, _lodash.pick)(query, ['id', 'query', 'ecs_mapping', 'version', 'platform'])
  })) : [];
  if (fleetActions.length) {
    var _osqueryContext$servi;
    await ((_osqueryContext$servi = osqueryContext.service.getFleetActionsClient()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.bulkCreate(fleetActions));
  }
  const actionsComponentTemplateExists = await esClientInternal.indices.exists({
    index: `${_constants.ACTIONS_INDEX}*`
  });
  if (actionsComponentTemplateExists) {
    await esClientInternal.bulk({
      refresh: 'wait_for',
      operations: [{
        index: {
          _index: `${_constants.ACTIONS_INDEX}-default`
        }
      }, osqueryAction]
    });
  }
  osqueryContext.telemetryEventsSender.reportEvent(_constants2.TELEMETRY_EBT_LIVE_QUERY_EVENT, {
    ...(0, _lodash.omit)(osqueryAction, ['type', 'input_type', 'user_id', 'error']),
    agents: osqueryAction.agents.length
  });
  return {
    response: osqueryAction,
    fleetActionsCount: fleetActions.length
  };
};
exports.createActionHandler = createActionHandler;