"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryNotAvailablePrompt = exports.OsqueryEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _osquery_icon = require("../components/osquery_icon");
var _translations = require("./osquery_action/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, null),
  title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.SHORT_EMPTY_TITLE),
  titleSize: "xs",
  body: /*#__PURE__*/_react.default.createElement("p", null, _translations.EMPTY_PROMPT)
});
exports.OsqueryEmptyPrompt = OsqueryEmptyPrompt;
const OsqueryNotAvailablePrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, null),
  title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.SHORT_EMPTY_TITLE),
  titleSize: "xs",
  body: /*#__PURE__*/_react.default.createElement("p", null, _translations.NOT_AVAILABLE)
});
exports.OsqueryNotAvailablePrompt = OsqueryNotAvailablePrompt;