"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateSavedQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _common = require("../../common");
var _page_paths = require("../common/page_paths");
var _constants2 = require("./constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateSavedQuery = ({
  savedQueryId
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    application: {
      navigateToApp
    },
    notifications: {
      toasts
    },
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useMutation)(payload => http.put(`/api/osquery/saved_queries/${savedQueryId}`, {
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(payload)
  }), {
    onError: error => {
      setErrorToast(error, {
        title: error.body.error,
        toastMessage: error.body.message
      });
    },
    onSuccess: payload => {
      var _payload$data$id;
      queryClient.invalidateQueries([_constants2.SAVED_QUERIES_ID]);
      queryClient.invalidateQueries([_constants2.SAVED_QUERY_ID, {
        savedQueryId
      }]);
      navigateToApp(_common.PLUGIN_ID, {
        path: _page_paths.pagePathGetters.saved_queries()
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.osquery.editSavedQuery.successToastMessageText', {
        defaultMessage: 'Successfully updated "{savedQueryName}" query',
        values: {
          savedQueryName: (_payload$data$id = payload.data.id) !== null && _payload$data$id !== void 0 ? _payload$data$id : ''
        }
      }));
    }
  });
};
exports.useUpdateSavedQuery = useUpdateSavedQuery;