"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTabs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _results_table = require("../../../results/results_table");
var _action_results_summary = require("../../../action_results/action_results_summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const euiTabbedContentCss = {
  'div.euiTabs': {
    paddingLeft: '8px'
  }
};
const ResultTabsComponent = ({
  actionId,
  agentIds,
  ecsMapping,
  endDate,
  failedAgentsCount,
  startDate,
  liveQueryActionId,
  error
}) => {
  const tabs = (0, _react.useMemo)(() => [{
    id: 'results',
    name: 'Results',
    'data-test-subj': 'osquery-results-tab',
    content: /*#__PURE__*/_react.default.createElement(_results_table.ResultsTable, {
      actionId: actionId,
      agentIds: agentIds,
      ecsMapping: ecsMapping,
      startDate: startDate,
      endDate: endDate,
      liveQueryActionId: liveQueryActionId,
      error: error
    })
  }, {
    id: 'status',
    name: 'Status',
    'data-test-subj': 'osquery-status-tab',
    content: /*#__PURE__*/_react.default.createElement(_action_results_summary.ActionResultsSummary, {
      startDate: startDate,
      actionId: actionId,
      agentIds: agentIds,
      expirationDate: endDate,
      error: error
    }),
    append: failedAgentsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m"
    }, failedAgentsCount) : null
  }], [actionId, agentIds, ecsMapping, startDate, endDate, liveQueryActionId, error, failedAgentsCount]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    css: euiTabbedContentCss
    // TODO: extend the EuiTabbedContent component to support EuiTabs props
    // bottomBorder={false}
    ,
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected",
    expand: false
  });
};
const ResultTabs = /*#__PURE__*/_react.default.memo(ResultTabsComponent);
exports.ResultTabs = ResultTabs;