"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewErrorsInLogsAction = exports.ScheduledQueryErrorsTable = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rison = require("@kbn/rison");
var _querystring = require("querystring");
var _kibana = require("../common/lib/kibana");
var _agent_id_to_name = require("../agents/agent_id_to_name");
var _use_pack_query_errors = require("./use_pack_query_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VIEW_IN_LOGS = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewLogsErrorsActionAriaLabel', {
  defaultMessage: 'View in Logs'
});
const ViewErrorsInLogsActionComponent = ({
  actionId,
  agentId,
  timestamp
}) => {
  const navigateToApp = (0, _kibana.useKibana)().services.application.navigateToApp;
  const handleClick = (0, _react.useCallback)(event => {
    const openInNewTab = !(!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event));
    event.preventDefault();
    const queryString = (0, _querystring.stringify)({
      logPosition: (0, _rison.encode)({
        end: timestamp,
        streamLive: false
      }),
      logFilter: (0, _rison.encode)({
        expression: `elastic_agent.id:${agentId} and (data_stream.dataset:elastic_agent or data_stream.dataset:elastic_agent.osquerybeat) and "${actionId}"`,
        kind: 'kuery'
      })
    });
    navigateToApp('logs', {
      path: `stream?${queryString}`,
      openInNewTab
    });
  }, [actionId, agentId, navigateToApp, timestamp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_LOGS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "search",
    onClick: handleClick,
    "aria-label": VIEW_IN_LOGS
  }));
};
const ViewErrorsInLogsAction = /*#__PURE__*/_react.default.memo(ViewErrorsInLogsActionComponent);
exports.ViewErrorsInLogsAction = ViewErrorsInLogsAction;
const renderErrorMessage = error => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  fontSize: "s",
  paddingSize: "none",
  transparentBackground: true
}, error);
const ScheduledQueryErrorsTableComponent = ({
  actionId,
  interval
}) => {
  var _lastErrorsData$hits;
  const {
    data: lastErrorsData
  } = (0, _use_pack_query_errors.usePackQueryErrors)({
    actionId,
    interval
  });
  const renderAgentIdColumn = (0, _react.useCallback)(agentId => /*#__PURE__*/_react.default.createElement(_agent_id_to_name.AgentIdToName, {
    agentId: agentId
  }), []);
  const renderLogsErrorsAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(ViewErrorsInLogsAction, {
    actionId: actionId,
    agentId: item === null || item === void 0 ? void 0 : item.fields['elastic_agent.id'][0],
    timestamp: item === null || item === void 0 ? void 0 : item.fields['event.ingested'][0]
  }), [actionId]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'fields.@timestamp',
    name: '@timestamp',
    width: '220px'
  }, {
    field: 'fields["elastic_agent.id"][0]',
    name: _i18n.i18n.translate('xpack.osquery.scheduledQueryErrorsTable.agentIdColumnTitle', {
      defaultMessage: 'Agent Id'
    }),
    truncateText: true,
    render: renderAgentIdColumn,
    width: '15%'
  }, {
    field: 'fields.message[0]',
    name: _i18n.i18n.translate('xpack.osquery.scheduledQueryErrorsTable.errorColumnTitle', {
      defaultMessage: 'Error'
    }),
    render: renderErrorMessage
  }, {
    width: '50px',
    actions: [{
      render: renderLogsErrorsAction
    }]
  }], [renderAgentIdColumn, renderLogsErrorsAction]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    // eslint-disable-next-line react-perf/jsx-no-new-array-as-prop
    items: (_lastErrorsData$hits = lastErrorsData === null || lastErrorsData === void 0 ? void 0 : lastErrorsData.hits) !== null && _lastErrorsData$hits !== void 0 ? _lastErrorsData$hits : [],
    columns: columns,
    pagination: true
  });
};
const ScheduledQueryErrorsTable = /*#__PURE__*/_react.default.memo(ScheduledQueryErrorsTableComponent);
exports.ScheduledQueryErrorsTable = ScheduledQueryErrorsTable;