"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _constants = require("../../../common/constants");
var _form = require("../../form");
var _code_editor_field = require("../../saved_queries/form/code_editor_field");
var _platform_checkbox_group_field = require("./platform_checkbox_group_field");
var _constants2 = require("./constants");
var _use_pack_query_form = require("./use_pack_query_form");
var _saved_queries_dropdown = require("../../saved_queries/saved_queries_dropdown");
var _lazy_ecs_mapping_editor_field = require("./lazy_ecs_mapping_editor_field");
var _kibana = require("../../common/lib/kibana");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryFlyoutComponent = ({
  uniqueQueryIds,
  defaultValue,
  onSave,
  onClose
}) => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [isEditMode] = (0, _react.useState)(!!defaultValue);
  const {
    serializer,
    idSet,
    ...hooksForm
  } = (0, _use_pack_query_form.usePackQueryForm)({
    uniqueQueryIds,
    defaultValue
  });
  const {
    handleSubmit,
    formState: {
      isSubmitting
    },
    resetField
  } = hooksForm;
  const onSubmit = async payload => {
    const serializedData = serializer(payload);
    await onSave(serializedData);
    onClose();
  };
  const handleSetQueryValue = (0, _react.useCallback)(savedQuery => {
    if (savedQuery) {
      var _savedQuery$snapshot, _savedQuery$ecs_mappi;
      resetField('id', {
        defaultValue: savedQuery.id
      });
      resetField('query', {
        defaultValue: savedQuery.query
      });
      resetField('platform', {
        defaultValue: savedQuery.platform ? savedQuery.platform : _constants.DEFAULT_PLATFORM
      });
      resetField('version', {
        defaultValue: savedQuery.version ? [savedQuery.version] : []
      });
      resetField('interval', {
        defaultValue: savedQuery.interval ? savedQuery.interval : 3600
      });
      resetField('timeout', {
        defaultValue: savedQuery.timeout ? savedQuery.timeout : _constants.QUERY_TIMEOUT.DEFAULT
      });
      resetField('snapshot', {
        defaultValue: (_savedQuery$snapshot = savedQuery.snapshot) !== null && _savedQuery$snapshot !== void 0 ? _savedQuery$snapshot : true
      });
      resetField('removed', {
        defaultValue: savedQuery.removed
      });
      resetField('ecs_mapping', {
        defaultValue: (_savedQuery$ecs_mappi = savedQuery.ecs_mapping) !== null && _savedQuery$ecs_mappi !== void 0 ? _savedQuery$ecs_mappi : {}
      });
    }
  }, [resetField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    onClose: onClose,
    "aria-labelledby": "flyoutTitle",
    ownFocus: true,
    outsideClickCloses: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.editFormTitle",
    defaultMessage: "Edit query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.addFormTitle",
    defaultMessage: "Attach next query"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, hooksForm, !isEditMode && permissions.readSavedQueries ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_saved_queries_dropdown.SavedQueriesDropdown, {
    onChange: handleSetQueryValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_form.QueryIdField, {
    idSet: idSet
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_code_editor_field.CodeEditorField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_form.IntervalField
  // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
  , {
    euiFieldProps: {
      append: 's'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form.VersionField
  // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
  , {
    euiFieldProps: {
      noSuggestions: false,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.osquery.queriesTable.osqueryVersionAllLabel', {
        defaultMessage: 'ALL'
      }),
      options: _constants2.ALL_OSQUERY_VERSIONS_OPTIONS,
      onCreateOption: undefined
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form.ResultsTypeField, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_platform_checkbox_group_field.PlatformCheckBoxGroupField, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_form.TimeoutField, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss
  }, /*#__PURE__*/_react.default.createElement(_lazy_ecs_mapping_editor_field.ECSMappingEditorField, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "query-flyout-cancel-button",
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "query-flyout-save-button",
    isLoading: isSubmitting,
    onClick: handleSubmit(onSubmit),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.saveButtonLabel",
    defaultMessage: "Save"
  }))))));
};
const QueryFlyout = /*#__PURE__*/_react.default.memo(QueryFlyoutComponent);
exports.QueryFlyout = QueryFlyout;