"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shards_policy_field = require("./shards_policy_field");
var _shards_percentage_field = require("./shards_percentage_field");
var _utils = require("../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShardsFormComponent = ({
  onDelete,
  index,
  isLastItem,
  control,
  options
}) => {
  const handleDeleteClick = (0, _react.useCallback)(() => {
    if (onDelete) {
      onDelete(index);
    }
  }, [index, onDelete]);
  const buttonWrapperCss = (0, _react.useCallback)(({
    euiTheme
  }) => index === 0 ? {
    marginTop: euiTheme.size.base
  } : {}, [index]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `packShardsForm-${index}`,
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss
  }, /*#__PURE__*/_react.default.createElement(_shards_policy_field.ShardsPolicyField, {
    index: index,
    control: control,
    hideLabel: index !== 0,
    options: options
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_shards_percentage_field.ShardsPercentageField, {
    index: index,
    control: control,
    hideLabel: index !== 0
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: buttonWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.osquery.pack.form.deleteShardsRowButtonAriaLabel', {
      defaultMessage: 'Delete shards row'
    }),
    iconType: "trash",
    color: "text",
    disabled: isLastItem,
    onClick: handleDeleteClick
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
const ShardsForm = /*#__PURE__*/_react.default.memo(ShardsFormComponent);
exports.ShardsForm = ShardsForm;