"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultShardData = exports.PackShardsField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _converters = require("../../../../common/utils/converters");
var _agent_policies = require("../../../agent_policies");
var _shards_form = require("./shards_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultShardData = {
  policy: {
    label: '',
    key: ''
  },
  percentage: 100
};
exports.defaultShardData = defaultShardData;
const PackShardsFieldComponent = ({
  options
}) => {
  const {
    watch: watchRoot,
    register: registerRoot,
    setValue: setValueRoot,
    formState: {
      errors: errorsRoot
    }
  } = (0, _reactHookForm.useFormContext)();
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const rootShards = watchRoot('shards');
  const initialShardsArray = (0, _react.useMemo)(() => {
    const initialConvertedShards = (0, _converters.convertShardsToArray)(rootShards, agentPoliciesById);
    if (!(0, _lodash.isEmpty)(initialConvertedShards)) {
      if (initialConvertedShards[initialConvertedShards.length - 1].policy.key) {
        return [...initialConvertedShards, defaultShardData];
      }
      return initialConvertedShards;
    }
    return [defaultShardData];
  }, [agentPoliciesById, rootShards]);
  const {
    control,
    watch,
    getFieldState,
    formState,
    resetField,
    setValue
  } = (0, _reactHookForm.useForm)({
    mode: 'all',
    shouldUnregister: true,
    defaultValues: {
      shardsArray: initialShardsArray
    }
  });
  const {
    fields,
    remove,
    append
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'shardsArray'
  });
  const formValue = watch();
  const shardsArrayState = getFieldState('shardsArray', formState);
  (0, _react.useEffect)(() => {
    registerRoot('shards', {
      validate: () => {
        const nonEmptyErrors = (0, _lodash.reject)(shardsArrayState.error, _lodash.isEmpty);
        return !nonEmptyErrors.length;
      }
    });
  }, [shardsArrayState.error, errorsRoot, registerRoot]);
  (0, _react.useEffect)(() => {
    const subscription = watch((data, payload) => {
      if (data !== null && data !== void 0 && data.shardsArray) {
        var _data$shardsArray, _payload$name;
        const lastShardIndex = (data === null || data === void 0 ? void 0 : (_data$shardsArray = data.shardsArray) === null || _data$shardsArray === void 0 ? void 0 : _data$shardsArray.length) - 1;
        if ((_payload$name = payload.name) !== null && _payload$name !== void 0 && _payload$name.startsWith(`shardsArray.${lastShardIndex}.`)) {
          var _lastShard$policy;
          const lastShard = (0, _lodash.last)(data.shardsArray);
          if (lastShard !== null && lastShard !== void 0 && (_lastShard$policy = lastShard.policy) !== null && _lastShard$policy !== void 0 && _lastShard$policy.key) {
            append(defaultShardData);
          }
        }
      }
    });
    return () => subscription.unsubscribe();
  }, [formValue, append, watch]);
  (0, _react.useEffect)(() => {
    const parsedShards = (0, _converters.convertShardsToObject)(formValue.shardsArray);
    if (shardsArrayState.isDirty && !(0, _fastDeepEqual.default)(parsedShards, rootShards)) {
      setValueRoot('shards', parsedShards, {
        shouldTouch: true
      });
    }
  }, [setValueRoot, formValue, shardsArrayState.isDirty, rootShards, resetField, setValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), fields.map((item, index, array) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.id
  }, /*#__PURE__*/_react.default.createElement(_shards_form.ShardsForm, {
    index: index,
    onDelete: remove,
    isLastItem: index === array.length - 1,
    control: control,
    options: options
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))));
};
const PackShardsField = /*#__PURE__*/_react.default.memo(PackShardsFieldComponent);
exports.PackShardsField = PackShardsField;