"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSelectedAgentsMessage = exports.SELECT_AGENT_LABEL = exports.NO_AGENT_AVAILABLE_TITLE = exports.FAIL_ALL_AGENTS = exports.ERROR_ALL_AGENTS = exports.ATTACHED_QUERY = exports.ALL_AGENTS_LABEL = exports.AGENT_SELECTION_LABEL = exports.AGENT_QUERY = exports.AGENT_POLICY_LABEL = exports.AGENT_PLATFORMS_LABEL = exports.AGENT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSelectedAgentsMessage = numAgents => {
  if (numAgents === 0) {
    return '';
  } else if (numAgents === 1) {
    return _i18n.i18n.translate('xpack.osquery.agents.oneSelectedAgentText', {
      defaultMessage: '{numAgents} agent selected.',
      values: {
        numAgents
      }
    });
  } else {
    return _i18n.i18n.translate('xpack.osquery.agents.mulitpleSelectedAgentsText', {
      defaultMessage: '{numAgents} agents selected.',
      values: {
        numAgents
      }
    });
  }
};
exports.generateSelectedAgentsMessage = generateSelectedAgentsMessage;
const ALL_AGENTS_LABEL = _i18n.i18n.translate('xpack.osquery.agents.allAgentsLabel', {
  defaultMessage: `All agents`
});
exports.ALL_AGENTS_LABEL = ALL_AGENTS_LABEL;
const AGENT_PLATFORMS_LABEL = _i18n.i18n.translate('xpack.osquery.agents.platformLabel', {
  defaultMessage: `Platform`
});
exports.AGENT_PLATFORMS_LABEL = AGENT_PLATFORMS_LABEL;
const AGENT_POLICY_LABEL = _i18n.i18n.translate('xpack.osquery.agents.policyLabel', {
  defaultMessage: `Policy`
});
exports.AGENT_POLICY_LABEL = AGENT_POLICY_LABEL;
const AGENT = _i18n.i18n.translate('xpack.osquery.agents.agent', {
  defaultMessage: `Agent`
});
exports.AGENT = AGENT;
const AGENT_SELECTION_LABEL = _i18n.i18n.translate('xpack.osquery.agents.selectionLabel', {
  defaultMessage: `Agents`
});
exports.AGENT_SELECTION_LABEL = AGENT_SELECTION_LABEL;
const NO_AGENT_AVAILABLE_TITLE = _i18n.i18n.translate('xpack.osquery.agents.noAgentAvailableTitle', {
  defaultMessage: `No agents available`
});
exports.NO_AGENT_AVAILABLE_TITLE = NO_AGENT_AVAILABLE_TITLE;
const AGENT_QUERY = _i18n.i18n.translate('xpack.osquery.agents.query', {
  defaultMessage: `Query`
});
exports.AGENT_QUERY = AGENT_QUERY;
const SELECT_AGENT_LABEL = _i18n.i18n.translate('xpack.osquery.agents.selectAgentLabel', {
  defaultMessage: `Select agents or groups to query`
});
exports.SELECT_AGENT_LABEL = SELECT_AGENT_LABEL;
const ERROR_ALL_AGENTS = _i18n.i18n.translate('xpack.osquery.agents.errorSearchDescription', {
  defaultMessage: `An error has occurred on all agents search`
});
exports.ERROR_ALL_AGENTS = ERROR_ALL_AGENTS;
const FAIL_ALL_AGENTS = _i18n.i18n.translate('xpack.osquery.agents.failSearchDescription', {
  defaultMessage: `Failed to fetch agents`
});
exports.FAIL_ALL_AGENTS = FAIL_ALL_AGENTS;
const ATTACHED_QUERY = _i18n.i18n.translate('xpack.osquery.agent.attachedQuery', {
  defaultMessage: `attached query` // as in 'User attached query 5 minutes ago'
});
exports.ATTACHED_QUERY = ATTACHED_QUERY;