"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StacktracesLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = _interopRequireDefault(require("query-string"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StacktracesLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", 'stacktracesLocator');
    (0, _defineProperty2.default)(this, "getLocation", async ({
      rangeFrom,
      rangeTo,
      kuery
    }) => {
      const params = {
        rangeFrom,
        rangeTo,
        kuery
      };
      return {
        app: 'profiling',
        path: `/stacktraces/threads?${_queryString.default.stringify(params)}`,
        state: {}
      };
    });
  }
}
exports.StacktracesLocatorDefinition = StacktracesLocatorDefinition;