"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParsedFilterQuery = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParsedFilterQuery = filter => {
  if (!filter) return [];
  try {
    const parsedQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(filter));
    return [parsedQuery];
  } catch (error) {
    return [];
  }
};
exports.getParsedFilterQuery = getParsedFilterQuery;