"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTempSummaryDocument = createTempSummaryDocument;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTempSummaryDocument(slo, spaceId) {
  var _slo$objective$timesl, _slo$objective$timesl2, _slo$objective$timesl3;
  return {
    service: {
      environment: null,
      name: null
    },
    transaction: {
      name: null,
      type: null
    },
    slo: {
      indicator: {
        type: slo.indicator.type
      },
      timeWindow: {
        duration: slo.timeWindow.duration.format(),
        type: slo.timeWindow.type
      },
      groupBy: !!slo.groupBy ? slo.groupBy : _sloSchema.ALL_VALUE,
      instanceId: _sloSchema.ALL_VALUE,
      name: slo.name,
      description: slo.description,
      id: slo.id,
      budgetingMethod: slo.budgetingMethod,
      revision: slo.revision,
      objective: {
        target: slo.objective.target,
        timesliceTarget: (_slo$objective$timesl = slo.objective.timesliceTarget) !== null && _slo$objective$timesl !== void 0 ? _slo$objective$timesl : null,
        timesliceWindow: (_slo$objective$timesl2 = (_slo$objective$timesl3 = slo.objective.timesliceWindow) === null || _slo$objective$timesl3 === void 0 ? void 0 : _slo$objective$timesl3.format()) !== null && _slo$objective$timesl2 !== void 0 ? _slo$objective$timesl2 : null
      },
      tags: slo.tags
    },
    goodEvents: 0,
    totalEvents: 0,
    errorBudgetEstimated: false,
    errorBudgetRemaining: 1,
    errorBudgetConsumed: 0,
    errorBudgetInitial: 1 - slo.objective.target,
    sliValue: -1,
    statusCode: 0,
    status: 'NO_DATA',
    isTempDoc: true,
    spaceId
  };
}