"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultSLOInstaller = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DefaultSLOInstaller {
  constructor(sloResourceInstaller, logger) {
    (0, _defineProperty2.default)(this, "isInstalling", false);
    this.sloResourceInstaller = sloResourceInstaller;
    this.logger = logger;
  }
  async install() {
    if (this.isInstalling) {
      return;
    }
    this.isInstalling = true;
    let installTimeout;
    try {
      installTimeout = setTimeout(() => this.isInstalling = false, 60000);
      await this.sloResourceInstaller.ensureCommonResourcesInstalled();
    } catch (error) {
      this.logger.error('Failed to install SLO common resources');
    } finally {
      this.isInstalling = false;
      clearTimeout(installTimeout);
    }
  }
}
exports.DefaultSLOInstaller = DefaultSLOInstaller;