"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetSLO {
  constructor(repository, summaryClient) {
    this.repository = repository;
    this.summaryClient = summaryClient;
  }
  async execute(sloId, params = {}) {
    var _params$instanceId;
    const slo = await this.repository.findById(sloId);
    const instanceId = (_params$instanceId = params.instanceId) !== null && _params$instanceId !== void 0 ? _params$instanceId : _sloSchema.ALL_VALUE;
    const summary = await this.summaryClient.computeSummary(slo, instanceId);
    return _sloSchema.getSLOResponseSchema.encode(mergeSloWithSummary(slo, summary, instanceId));
  }
}
exports.GetSLO = GetSLO;
function mergeSloWithSummary(slo, summary, instanceId) {
  return {
    ...slo,
    instanceId,
    summary
  };
}