"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAlertDetailsEnabledPerApp = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALLOWED_RULE_TYPES = ['apm.transaction_duration', 'logs.alert.document.count'];
const isUnsafeAlertDetailsFlag = subject => ['uptime', 'metrics', 'observability'].includes(subject);

// We are mapping the ruleTypeId from the feature flag with the ruleTypeId from the alert
// to know whether the feature flag is enabled or not.
const isAlertDetailsEnabledPerApp = (alert, config) => {
  if (!alert) return false;
  const ruleTypeId = alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID];

  // The feature flags for alertDetails are not specific enough so we need to check
  // the specific rule types to see if they should be blocked or not.
  if (ALLOWED_RULE_TYPES.includes(ruleTypeId)) {
    return true;
  }
  if (!config) return false;

  // Since we are moving away from feature flags, this code will eventually be removed.
  const appNameFromAlertRuleType = ruleTypeId === 'xpack.uptime.alerts.monitorStatus' || ruleTypeId === 'xpack.uptime.alerts.tlsCertificate' ? 'uptime' : ruleTypeId.split('.')[0];
  if (isUnsafeAlertDetailsFlag(appNameFromAlertRuleType)) {
    var _config$unsafe, _config$unsafe$alertD;
    return (_config$unsafe = config.unsafe) === null || _config$unsafe === void 0 ? void 0 : (_config$unsafe$alertD = _config$unsafe.alertDetails[appNameFromAlertRuleType]) === null || _config$unsafe$alertD === void 0 ? void 0 : _config$unsafe$alertD.enabled;
  }
  return false;
};
exports.isAlertDetailsEnabledPerApp = isAlertDetailsEnabledPerApp;