"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityRuleTypes = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_view_in_app_url = require("../../common/custom_threshold_rule/get_view_in_app_url");
var _slo = require("../../common/field_names/slo");
var _constants = require("../../common/constants");
var _validation = require("../components/burn_rate_rule_editor/validation");
var _validation2 = require("../components/custom_threshold/components/validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const sloBurnRateDefaultActionMessage = _i18n.i18n.translate('xpack.observability.slo.rules.burnRate.defaultActionMessage', {
  defaultMessage: `\\{\\{context.reason\\}\\}

\\{\\{rule.name\\}\\} is active with the following conditions:

- SLO: \\{\\{context.sloName\\}\\}'
- The burn rate over the last \\{\\{context.longWindow.duration\\}\\} is \\{\\{context.longWindow.burnRate\\}\\}
- The burn rate over the last \\{\\{context.shortWindow.duration\\}\\} is \\{\\{context.shortWindow.burnRate\\}\\}
- Threshold: \\{\\{context.burnRateThreshold\\}\\}

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const sloBurnRateDefaultRecoveryMessage = _i18n.i18n.translate('xpack.observability.slo.rules.burnRate.defaultRecoveryMessage', {
  defaultMessage: `\\{\\{context.reason\\}\\}

\\{\\{rule.name\\}\\} has recovered.

- SLO: \\{\\{context.sloName\\}\\}'
- The burn rate over the last \\{\\{context.longWindow.duration\\}\\} is \\{\\{context.longWindow.burnRate\\}\\}
- The burn rate over the last \\{\\{context.shortWindow.duration\\}\\} is \\{\\{context.shortWindow.burnRate\\}\\}
- Threshold: \\{\\{context.burnRateThreshold\\}\\}

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const thresholdDefaultActionMessage = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alerting.threshold.defaultActionMessage', {
  defaultMessage: `\\{\\{context.reason\\}\\}

\\{\\{rule.name\\}\\} is active.

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const thresholdDefaultRecoveryMessage = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alerting.threshold.defaultRecoveryMessage', {
  defaultMessage: `\\{\\{rule.name\\}\\} has recovered.

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const getDataViewId = searchConfiguration => {
  var _searchConfiguration$;
  return typeof (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index) === 'string' ? searchConfiguration.index : searchConfiguration === null || searchConfiguration === void 0 ? void 0 : (_searchConfiguration$ = searchConfiguration.index) === null || _searchConfiguration$ === void 0 ? void 0 : _searchConfiguration$.title;
};
const registerObservabilityRuleTypes = async (config, observabilityRuleTypeRegistry, logExplorerLocator) => {
  observabilityRuleTypeRegistry.register({
    id: _constants.SLO_BURN_RATE_RULE_TYPE_ID,
    description: _i18n.i18n.translate('xpack.observability.slo.rules.burnRate.description', {
      defaultMessage: 'Alert when your SLO burn rate is too high over a defined period of time.'
    }),
    format: ({
      fields
    }) => {
      var _fields$ALERT_REASON, _fields$SLO_INSTANCE_;
      return {
        reason: (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '-',
        link: `/app/observability/slos/${fields[_slo.SLO_ID_FIELD]}?instanceId=${(_fields$SLO_INSTANCE_ = fields[_slo.SLO_INSTANCE_ID_FIELD]) !== null && _fields$SLO_INSTANCE_ !== void 0 ? _fields$SLO_INSTANCE_ : '*'}`
      };
    },
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.sloBurnRateRule}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/burn_rate_rule_editor')))),
    validate: _validation.validateBurnRateRule,
    requiresAppContext: false,
    defaultActionMessage: sloBurnRateDefaultActionMessage,
    defaultRecoveryMessage: sloBurnRateDefaultRecoveryMessage,
    priority: 100
  });
  observabilityRuleTypeRegistry.register({
    id: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
    description: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertDescription', {
      defaultMessage: 'Alert when any Observability data type reaches or exceeds a given value.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.customThreshold}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/custom_threshold/custom_threshold_rule_expression')))),
    validate: _validation2.validateCustomThreshold,
    defaultActionMessage: thresholdDefaultActionMessage,
    defaultRecoveryMessage: thresholdDefaultRecoveryMessage,
    requiresAppContext: false,
    format: ({
      fields
    }) => {
      var _fields$ALERT_RULE_PA, _fields$ALERT_RULE_PA2, _fields$ALERT_REASON2;
      const searchConfiguration = (_fields$ALERT_RULE_PA = fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _fields$ALERT_RULE_PA === void 0 ? void 0 : _fields$ALERT_RULE_PA.searchConfiguration;
      const criteria = (_fields$ALERT_RULE_PA2 = fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _fields$ALERT_RULE_PA2 === void 0 ? void 0 : _fields$ALERT_RULE_PA2.criteria;
      const metrics = criteria.length === 1 ? criteria[0].metrics : [];
      const dataViewId = getDataViewId(searchConfiguration);
      return {
        reason: (_fields$ALERT_REASON2 = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON2 !== void 0 ? _fields$ALERT_REASON2 : '-',
        link: (0, _get_view_in_app_url.getViewInAppUrl)(metrics, fields[_ruleDataUtils.ALERT_START], logExplorerLocator, (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.query).query, dataViewId),
        hasBasePath: true
      };
    },
    alertDetailsAppSection: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/custom_threshold/components/alert_details_app_section')))),
    priority: 5
  });
};
exports.registerObservabilityRuleTypes = registerObservabilityRuleTypes;